/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.trade.service.impl.hb;

import com.alipay.trade.model.hb.HbStatus;
import com.alipay.trade.model.hb.SysTradeInfo;
import com.alipay.trade.service.impl.hb.HbQueue;
import com.alipay.trade.service.impl.hb.TradeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HbListener
implements TradeListener {
    private static Log log = LogFactory.getLog(HbListener.class);

    private void offerTradeInfo(String outTradeNo, long beforeCall, HbStatus status) {
        long afterCall = System.currentTimeMillis();
        double timeConsume = (double)(afterCall - beforeCall) / 1000.0;
        log.debug((Object)(outTradeNo + " offer " + (Object)((Object)status) + ": " + timeConsume));
        HbQueue.offer(SysTradeInfo.newInstance(outTradeNo, timeConsume, status));
    }

    @Override
    public void onPayTradeSuccess(String outTradeNo, long beforeCall) {
        this.offerTradeInfo(outTradeNo, beforeCall, HbStatus.S);
    }

    @Override
    public void onPayInProgress(String outTradeNo, long beforeCall) {
        this.offerTradeInfo(outTradeNo, beforeCall, HbStatus.I);
    }

    @Override
    public void onPayFailed(String outTradeNo, long beforeCall) {
        this.offerTradeInfo(outTradeNo, beforeCall, HbStatus.F);
    }

    @Override
    public void onConnectException(String outTradeNo, long beforeCall) {
        this.offerTradeInfo(outTradeNo, beforeCall, HbStatus.X);
    }

    @Override
    public void onSendException(String outTradeNo, long beforeCall) {
        this.offerTradeInfo(outTradeNo, beforeCall, HbStatus.Y);
    }

    @Override
    public void onReceiveException(String outTradeNo, long beforeCall) {
        this.offerTradeInfo(outTradeNo, beforeCall, HbStatus.Z);
    }
}

