/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.alipay.core;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.alipay.trade.model.ExtendParams;
import com.alipay.trade.model.builder.AlipayTradeCancelRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradePayRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradePrecreateRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradeQueryRequestBuilder;
import com.alipay.trade.model.builder.AlipayTradeRefundRequestBuilder;
import com.alipay.trade.model.result.AlipayF2FCancelResult;
import com.alipay.trade.model.result.AlipayF2FPayResult;
import com.alipay.trade.model.result.AlipayF2FPrecreateResult;
import com.alipay.trade.model.result.AlipayF2FQueryResult;
import com.alipay.trade.model.result.AlipayF2FRefundResult;
import com.alipay.trade.service.AlipayTradeService;
import com.alipay.trade.service.impl.AlipayTradeServiceImpl;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.thlws.payment.alipay.entity.request.AlipayMobileSiteRequest;
import org.thlws.payment.alipay.entity.request.AlipayQrcodeRequest;
import org.thlws.payment.alipay.entity.request.AlipayRefundRequest;
import org.thlws.payment.alipay.entity.request.AlipayTradeRequest;
import org.thlws.payment.alipay.entity.request.AlipayWebSiteRequest;
import org.thlws.payment.alipay.entity.response.AlipayCancelResponse;
import org.thlws.payment.alipay.entity.response.AlipayQrcodeResponse;
import org.thlws.payment.alipay.entity.response.AlipayQueryResponse;
import org.thlws.payment.alipay.entity.response.AlipayRefundResponse;
import org.thlws.payment.alipay.entity.response.AlipayTradeResponse;
import org.thlws.utils.JsonUtil;

public class AlipayCore {
    private static final Log log = LogFactory.get();
    private AlipayTradeService tradeService;
    private ClientBuilder builder;

    private AlipayCore(ClientBuilder builder) {
        if (StringUtils.isEmpty((String)builder.getAppId())) {
            throw new NullPointerException("appid should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getPrivateKey())) {
            throw new NullPointerException("private should not be NULL!");
        }
        this.builder = builder;
        AlipayTradeServiceImpl.ClientBuilder alipayTradebuilder = new AlipayTradeServiceImpl.ClientBuilder();
        alipayTradebuilder.setAlipayPublicKey(builder.getAlipayPublicKey());
        alipayTradebuilder.setAppid(builder.getAppId());
        alipayTradebuilder.setCharset("utf-8");
        alipayTradebuilder.setFormat("json");
        alipayTradebuilder.setGatewayUrl("https://openapi.alipay.com/gateway.do");
        alipayTradebuilder.setPrivateKey(builder.getPrivateKey());
        alipayTradebuilder.setSignType(builder.getSignType());
        this.tradeService = alipayTradebuilder.build();
    }

    public String payInMobileSite(AlipayMobileSiteRequest request) throws Exception {
        log.debug("payInMobileSite request=\n" + request.toString(), new Object[0]);
        String form = "<font style='color: red'>\u8bf7\u6c42\u652f\u4ed8\u5b9d\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5!</font>";
        try {
            if (null == this.builder) {
                throw new Exception("Please set AlipayCore.ClientBuider first.");
            }
            String bizContent = JsonUtil.beanToJsontring(request.getBizContent());
            DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", this.builder.getAppId(), this.builder.getPrivateKey(), "json", "utf-8", this.builder.getAlipayPublicKey());
            AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
            alipayRequest.setReturnUrl(request.getReturnUrl());
            alipayRequest.setNotifyUrl(request.getNotifyUrl());
            alipayRequest.setBizContent(bizContent);
            form = ((AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest)).getBody();
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                log.debug("payInMobileSite response={}", new Object[]{form});
                throw throwable;
            }
        }
        log.debug("payInMobileSite response={}", new Object[]{form});
        return form;
    }

    public String payInWebSite(AlipayWebSiteRequest request) throws Exception {
        log.debug("payInWebSite request=\n" + request.toString(), new Object[0]);
        String form = "<font style='color: red'>\u8bf7\u6c42\u652f\u4ed8\u5b9d\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5!</font>";
        try {
            if (null == this.builder) {
                throw new Exception("Please set AlipayCore.ClientBuider first.");
            }
            String bizContent = JsonUtil.beanToJsontring(request.getBizContent());
            DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", this.builder.getAppId(), this.builder.getPrivateKey(), "json", "utf-8", this.builder.getAlipayPublicKey());
            AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
            alipayRequest.setReturnUrl(request.getReturnUrl());
            alipayRequest.setNotifyUrl(request.getNotifyUrl());
            alipayRequest.setBizContent(bizContent);
            form = ((AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest)).getBody();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        finally {
            log.debug("payInWebSite response=\n" + form, new Object[0]);
        }
        return form;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AlipayQrcodeResponse preCreate(AlipayQrcodeRequest request) throws Exception {
        log.debug("preCreate request=\n" + request.toString(), new Object[0]);
        AlipayQrcodeResponse response = new AlipayQrcodeResponse();
        try {
            if (null == this.tradeService) {
                throw new Exception("Please set AlipayCore.ClientBuider first and call build().");
            }
            ExtendParams extendParams = new ExtendParams();
            AlipayTradePrecreateRequestBuilder builder = new AlipayTradePrecreateRequestBuilder().setSubject(request.getSubject()).setTotalAmount(request.getTotalAmount()).setOutTradeNo(request.getOutTradeNo()).setUndiscountableAmount(request.getUndiscountableAmount()).setSellerId(request.getSellerId()).setBody(request.getBody()).setOperatorId(request.getOperatorId()).setStoreId(request.getStoreId()).setExtendParams(extendParams);
            AlipayF2FPrecreateResult result = this.tradeService.tradePrecreate(builder);
            response.setSuccess(result.isTradeSuccess());
            response.setSubCode(result.getResponse().getSubCode());
            response.setSubMsg(result.getResponse().getSubMsg());
            response.setCode(result.getResponse().getCode());
            response.setMsg(result.getResponse().getMsg());
            switch (result.getTradeStatus()) {
                case SUCCESS: {
                    response.setDesc("\u652f\u4ed8\u5b9d\u9884\u4e0b\u5355\u6210\u529f");
                    response.setOutTradeNo(result.getResponse().getOutTradeNo());
                    response.setQrCode(result.getResponse().getQrCode());
                    return response;
                }
                case FAILED: {
                    response.setDesc("\u652f\u4ed8\u5b9d\u9884\u4e0b\u5355\u5931\u8d25!");
                    return response;
                }
                case UNKNOWN: {
                    response.setDesc("\u7cfb\u7edf\u5f02\u5e38\uff0c\u9884\u4e0b\u5355\u72b6\u6001\u672a\u77e5!");
                    return response;
                }
                default: {
                    response.setDesc("\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!");
                    return response;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        finally {
            log.debug("precreate response=\n" + response.toString(), new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AlipayTradeResponse pay(AlipayTradeRequest request) throws Exception {
        log.debug("pay request=\n" + request.toString(), new Object[0]);
        AlipayTradeResponse response = new AlipayTradeResponse();
        try {
            if (null == this.tradeService) {
                throw new Exception("Please set AlipayCore.ClientBuider first and call build().");
            }
            String providerId = "2088100200300400500";
            ExtendParams extendParams = new ExtendParams();
            extendParams.setSysServiceProviderId(providerId);
            AlipayTradePayRequestBuilder builder = new AlipayTradePayRequestBuilder().setOutTradeNo(request.getOutTradeNo()).setSubject(request.getSubject()).setAuthCode(request.getAuthCode()).setTotalAmount(request.getTotalAmount()).setStoreId(request.getStoreId()).setUndiscountableAmount(request.getUndiscountableAmount()).setBody(request.getBody()).setOperatorId(request.getOperatorId()).setExtendParams(extendParams).setSellerId(request.getSellerId()).setGoodsDetailList(request.getGoodsDetailList());
            AlipayF2FPayResult result = this.tradeService.tradePay(builder);
            response.setSuccess(result.isTradeSuccess());
            response.setSubCode(result.getResponse().getSubCode());
            response.setSubMsg(result.getResponse().getSubMsg());
            response.setCode(result.getResponse().getCode());
            response.setMsg(result.getResponse().getMsg());
            switch (result.getTradeStatus()) {
                case SUCCESS: {
                    BeanUtilsBean copyBean = BeanUtilsBean.getInstance();
                    copyBean.copyProperties((Object)response, (Object)result.getResponse());
                    response.setDesc("\u652f\u4ed8\u5b9d\u652f\u4ed8\u6210\u529f");
                    return response;
                }
                case FAILED: {
                    response.setDesc("\u652f\u4ed8\u5b9d\u652f\u4ed8\u5931\u8d25");
                    return response;
                }
                case UNKNOWN: {
                    response.setDesc("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5!");
                    return response;
                }
                default: {
                    response.setDesc("\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!");
                    return response;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        finally {
            log.debug("pay response=\n" + response.toString(), new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AlipayQueryResponse query(String outTradeNo) throws Exception {
        log.debug("query outTradeNo=" + outTradeNo, new Object[0]);
        AlipayQueryResponse response = new AlipayQueryResponse();
        try {
            if (null == this.tradeService) {
                throw new Exception("Please set AlipayCore.ClientBuider first and call build().");
            }
            AlipayTradeQueryRequestBuilder builder = new AlipayTradeQueryRequestBuilder().setOutTradeNo(outTradeNo);
            AlipayF2FQueryResult result = this.tradeService.queryTradeResult(builder);
            response.setSuccess(result.isTradeSuccess());
            response.setSubCode(result.getResponse().getSubCode());
            response.setSubMsg(result.getResponse().getSubMsg());
            response.setCode(result.getResponse().getCode());
            response.setMsg(result.getResponse().getMsg());
            switch (result.getTradeStatus()) {
                case SUCCESS: {
                    BeanUtilsBean copyBean = BeanUtilsBean.getInstance();
                    copyBean.copyProperties((Object)response, (Object)result.getResponse());
                    response.setDesc("\u67e5\u8be2\u8fd4\u56de\u8be5\u8ba2\u5355\u4fe1\u606f\u6210\u529f");
                    response.setCode(result.getResponse().getCode());
                    response.setMsg(result.getResponse().getMsg());
                    return response;
                }
                case FAILED: {
                    response.setDesc("\u67e5\u8be2\u8fd4\u56de\u8be5\u8ba2\u5355\u652f\u4ed8\u5931\u8d25\u6216\u88ab\u5173\u95ed!");
                    return response;
                }
                case UNKNOWN: {
                    response.setDesc("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u672a\u77e5!");
                    return response;
                }
                default: {
                    response.setDesc("\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!");
                    return response;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        finally {
            log.debug("query response=\n" + response.toString(), new Object[0]);
        }
    }

    public AlipayRefundResponse refund(AlipayRefundRequest request) throws Exception {
        log.debug("refund request=\n" + request.toString(), new Object[0]);
        AlipayRefundResponse response = new AlipayRefundResponse();
        try {
            if (null == this.tradeService) {
                throw new Exception("Please set AlipayCore.ClientBuider first and call build().");
            }
            AlipayTradeRefundRequestBuilder builder = new AlipayTradeRefundRequestBuilder();
            if (StringUtils.isBlank((String)request.getOutTradeNo()) && StringUtils.isBlank((String)request.getTradeNo())) {
                throw new Exception("trade_no , out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)request.getRefundAmount())) {
                throw new Exception("refundAmount \u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((String)request.getOutTradeNo())) {
                builder.setOutTradeNo(request.getOutTradeNo());
            }
            if (StringUtils.isNotBlank((String)request.getTradeNo())) {
                builder.setTradeNo(request.getTradeNo());
            }
            if (StringUtils.isNotBlank((String)request.getRefundReason())) {
                builder.setRefundReason(request.getRefundReason());
            }
            if (StringUtils.isNotBlank((String)request.getStoreId())) {
                builder.setStoreId(request.getStoreId());
            }
            if (StringUtils.isNotBlank((String)request.getOutRequestNo())) {
                builder.setOutRequestNo(request.getOutRequestNo());
            }
            if (StringUtils.isNotBlank((String)builder.getOutTradeNo()) && StringUtils.isNotBlank((String)builder.getTradeNo())) {
                builder.setTradeNo(null);
            }
            builder.setRefundAmount(request.getRefundAmount());
            AlipayF2FRefundResult result = this.tradeService.tradeRefund(builder);
            response.setSuccess(result.isTradeSuccess());
            response.setSubCode(result.getResponse().getSubCode());
            response.setSubMsg(result.getResponse().getSubMsg());
            response.setCode(result.getResponse().getCode());
            response.setMsg(result.getResponse().getMsg());
            switch (result.getTradeStatus()) {
                case SUCCESS: {
                    BeanUtilsBean copyBean = BeanUtilsBean.getInstance();
                    copyBean.copyProperties((Object)response, (Object)result.getResponse());
                    response.setDesc("\u652f\u4ed8\u5b9d\u9000\u6b3e\u6210\u529f");
                    break;
                }
                case FAILED: {
                    response.setDesc("\u652f\u4ed8\u5b9d\u9000\u6b3e\u5931\u8d25");
                    break;
                }
                case UNKNOWN: {
                    response.setDesc("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u9000\u6b3e\u72b6\u6001\u672a\u77e5!");
                    break;
                }
                default: {
                    response.setDesc("\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!");
                }
            }
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                log.debug("refund response={}", new Object[]{response.toString()});
                throw throwable;
            }
        }
        log.debug("refund response={}", new Object[]{response.toString()});
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AlipayCancelResponse cancel(String outTradeNo) throws Exception {
        AlipayCancelResponse response = new AlipayCancelResponse();
        try {
            AlipayTradeCancelRequestBuilder builder = new AlipayTradeCancelRequestBuilder();
            builder.setOutTradeNo(outTradeNo);
            AlipayF2FCancelResult result = this.tradeService.tradeCancel_II(builder);
            response.setSuccess(result.isTradeSuccess());
            switch (result.getTradeStatus()) {
                case SUCCESS: {
                    BeanUtilsBean copyBean = BeanUtilsBean.getInstance();
                    copyBean.copyProperties((Object)response, (Object)result.getResponse());
                    response.setDesc("\u652f\u4ed8\u5b9d\u64a4\u9500\u6210\u529f");
                    response.setCode(result.getResponse().getCode());
                    response.setMsg(result.getResponse().getMsg());
                    return response;
                }
                case FAILED: {
                    response.setDesc("\u652f\u4ed8\u5b9d\u64a4\u9500\u5931\u8d25");
                    response.setSubCode(result.getResponse().getSubCode());
                    response.setSubMsg(result.getResponse().getSubMsg());
                    response.setCode(result.getResponse().getCode());
                    response.setMsg(result.getResponse().getMsg());
                    return response;
                }
                case UNKNOWN: {
                    response.setDesc("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u64a4\u9500\u72b6\u6001\u672a\u77e5!");
                    response.setSubCode(result.getResponse().getSubCode());
                    response.setSubMsg(result.getResponse().getSubMsg());
                    response.setCode(result.getResponse().getCode());
                    response.setMsg(result.getResponse().getMsg());
                    return response;
                }
                default: {
                    response.setDesc("\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38!");
                    response.setSubCode(result.getResponse().getSubCode());
                    response.setSubMsg(result.getResponse().getSubMsg());
                    response.setCode(result.getResponse().getCode());
                    response.setMsg(result.getResponse().getMsg());
                    return response;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        finally {
            log.debug("cancel response=\n" + response.toString(), new Object[0]);
        }
    }

    public static class ClientBuilder {
        private String privateKey;
        private String alipayPublicKey;
        private String appId;
        private String signType;

        public AlipayCore build() {
            if (StringUtils.isEmpty((String)this.appId)) {
                throw new NullPointerException("please set appid first!");
            }
            if (StringUtils.isEmpty((String)this.privateKey)) {
                throw new NullPointerException("please set private_key first!");
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                throw new NullPointerException("please set sign_type first!");
            }
            if (this.signType.equalsIgnoreCase("RSA2") && StringUtils.isEmpty((String)this.alipayPublicKey)) {
                throw new NullPointerException("please set alipay_public_key first,when the sign_type is RSA2!");
            }
            if (StringUtils.isEmpty((String)this.alipayPublicKey) && this.signType.equalsIgnoreCase("RSA2")) {
                throw new NullPointerException("please set alipay_public_key first,when you using RSA2");
            }
            return new AlipayCore(this);
        }

        private String getPrivateKey() {
            return this.privateKey;
        }

        public ClientBuilder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        private String getAlipayPublicKey() {
            return this.alipayPublicKey;
        }

        public ClientBuilder setAlipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
            return this;
        }

        public String getAppId() {
            return this.appId;
        }

        public ClientBuilder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public String getSignType() {
            return this.signType;
        }

        public ClientBuilder setSignType(String signType) {
            this.signType = signType;
            return this;
        }
    }
}

