/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.alipay.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.thlws.payment.alipay.entity.response.AlipayNotifyResponse;
import org.thlws.payment.alipay.utils.VeryfyUtil;
import org.thlws.sign.RSA;

public class AlipayUtil {
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";

    public AlipayNotifyResponse verify(HttpServletRequest alipayRequest, String partner, String alipayPublicKey) {
        AlipayNotifyResponse output = new AlipayNotifyResponse();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            Map requestParams = alipayRequest.getParameterMap();
            for (String name : requestParams.keySet()) {
                String[] values = (String[])requestParams.get(name);
                String valueStr = "";
                for (int i = 0; i < values.length; ++i) {
                    valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
                }
                params.put(name, valueStr);
            }
            String outTradeNo = new String(alipayRequest.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String tradeNo = new String(alipayRequest.getParameter("trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String tradeStatus = new String(alipayRequest.getParameter("trade_status").getBytes("ISO-8859-1"), "UTF-8");
            boolean verifyFlg = AlipayUtil.verify(params, partner, alipayPublicKey);
            output.setVerifyFlg(verifyFlg);
            output.setOutTradeNo(outTradeNo);
            output.setTradeNo(tradeNo);
            output.setTradeStatus(tradeStatus);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return output;
    }

    private static boolean verify(Map<String, String> params, String partner, String alipayPublicKey) {
        boolean isSign;
        String responseTxt = "false";
        if (params.get("notify_id") != null) {
            String notifyId = params.get("notify_id");
            responseTxt = AlipayUtil.verifyResponse(notifyId, partner);
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return (isSign = AlipayUtil.getSignVeryfy(params, sign, alipayPublicKey)) && responseTxt.equals("true");
    }

    private static boolean getSignVeryfy(Map<String, String> params, String sign, String alipayPublicKey) {
        Map<String, String> sParaNew = VeryfyUtil.paraFilter(params);
        String preSignStr = VeryfyUtil.createLinkString(sParaNew);
        boolean isSign = false;
        isSign = RSA.verify(preSignStr, sign, alipayPublicKey, "utf-8");
        return isSign;
    }

    private static String verifyResponse(String notifyId, String partner) {
        String veryfyUrl = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notifyId;
        return AlipayUtil.checkUrl(veryfyUrl);
    }

    private static String checkUrl(String urlValue) {
        String inputLine;
        try {
            URL url = new URL(urlValue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            inputLine = "";
        }
        return inputLine;
    }
}

