/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.bestpay.core;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.util.Map;
import org.thlws.payment.bestpay.api.BestpayApi;
import org.thlws.payment.bestpay.entity.request.BarcodePayRequest;
import org.thlws.payment.bestpay.entity.request.OrderRefundRequest;
import org.thlws.payment.bestpay.entity.request.OrderReverseRequest;
import org.thlws.payment.bestpay.entity.request.QueryOrderRequest;
import org.thlws.payment.bestpay.entity.response.OrderRefundResponse;
import org.thlws.payment.bestpay.entity.response.OrderResultResponse;
import org.thlws.payment.bestpay.entity.response.OrderReverseResponse;
import org.thlws.sign.MD5;
import org.thlws.utils.ThlwsBeanUtil;

public class BestpayCore
implements BestpayApi {
    private static final Log log = LogFactory.get();

    public static OrderResultResponse barcode(BarcodePayRequest request, String key) throws Exception {
        OrderResultResponse out = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("MERCHANTID=").append(request.getMerchantId());
            sb.append("&ORDERNO=").append(request.getOrderNo());
            sb.append("&ORDERREQNO=").append(request.getOrderReqNo());
            sb.append("&ORDERDATE=").append(request.getOrderDate());
            sb.append("&BARCODE=").append(request.getBarcode());
            sb.append("&ORDERAMT=").append(request.getOrderAmt());
            sb.append("&KEY=").append(key);
            String mac = MD5.sign(sb.toString());
            Map map = BeanUtil.beanToMap((Object)request, (boolean)false, (boolean)true);
            map.put("mac", mac);
            log.debug("\u5929\u7ffc\u626b\u7801\u652f\u4ed8\u8bf7\u6c42\u6570\u636e[barcode]->request:\n {}", new Object[]{ThlwsBeanUtil.formatJson(map)});
            String result = HttpUtil.get((String)"https://webpaywg.bestpay.com.cn/barcode/placeOrder", (Map)map);
            log.debug("\u5929\u7ffc\u626b\u7801\u652f\u4ed8\u8fd4\u56de\u6570\u636e[barcode]->response \n : {}", new Object[]{ThlwsBeanUtil.formatJson(result)});
            out = (OrderResultResponse)JSONUtil.toBean((String)result, OrderResultResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return out;
    }

    public static OrderResultResponse query(QueryOrderRequest request, String key) throws Exception {
        OrderResultResponse out = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("MERCHANTID=").append(request.getMerchantId());
            sb.append("&ORDERNO=").append(request.getOrderNo());
            sb.append("&ORDERREQNO=").append(request.getOrderReqNo());
            sb.append("&ORDERDATE=").append(request.getOrderDate());
            sb.append("&KEY=").append(key);
            String mac = MD5.sign(sb.toString());
            Map map = BeanUtil.beanToMap((Object)request, (boolean)false, (boolean)true);
            map.put("mac", mac);
            log.debug("\u7ffc\u652f\u4ed8\u67e5\u8be2\u8bf7\u6c42\u6570\u636e[query]->request:\n {}", new Object[]{ThlwsBeanUtil.formatJson(map)});
            String result = HttpUtil.get((String)"https://webpaywg.bestpay.com.cn/query/queryOrder", (Map)map);
            log.debug("\u7ffc\u652f\u4ed8\u67e5\u8be2\u8fd4\u56de\u6570\u636e[query]->response \n : {}", new Object[]{ThlwsBeanUtil.formatJson(result)});
            out = (OrderResultResponse)JSONUtil.toBean((String)result, OrderResultResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return out;
    }

    public static OrderRefundResponse refund(OrderRefundRequest request, String key) throws Exception {
        OrderRefundResponse out = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("MERCHANTID=").append(request.getMerchantId());
            sb.append("&MERCHANTPWD=").append(request.getMerchantPwd());
            sb.append("&OLDORDERNO=").append(request.getOldOrderNo());
            sb.append("&OLDORDERREQNO=").append(request.getOldOrderReqNo());
            sb.append("&REFUNDREQNO=").append(request.getRefundReqNo());
            sb.append("&REFUNDREQDATE=").append(request.getRefundReqDate());
            sb.append("&TRANSAMT=").append(request.getTransAmt());
            sb.append("&LEDGERDETAIL=").append(request.getLedgerDetail());
            sb.append("&KEY=").append(key);
            String mac = MD5.sign(sb.toString());
            Map map = BeanUtil.beanToMap((Object)request, (boolean)false, (boolean)true);
            map.put("mac", mac);
            log.debug("\u7ffc\u652f\u4ed8\u9000\u6b3e\u8bf7\u6c42\u6570\u636e[refund]->request:\n {}", new Object[]{ThlwsBeanUtil.formatJson(map)});
            String result = HttpUtil.post((String)"https://webpaywg.bestpay.com.cn/refund/commonRefund", (Map)map);
            log.debug("\u7ffc\u652f\u4ed8\u9000\u6b3e\u8fd4\u56de\u6570\u636e[refund]->response \n : {}", new Object[]{ThlwsBeanUtil.formatJson(result)});
            out = (OrderRefundResponse)JSONUtil.toBean((String)result, OrderRefundResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return out;
    }

    public static OrderReverseResponse reverse(OrderReverseRequest request, String key) throws Exception {
        OrderReverseResponse out = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("MERCHANTID=").append(request.getMerchantId());
            sb.append("&MERCHANTPWD=").append(request.getMerchantPwd());
            sb.append("&OLDORDERNO=").append(request.getOldOrderNo());
            sb.append("&OLDORDERREQNO=").append(request.getOldOrderReqNo());
            sb.append("&REFUNDREQNO=").append(request.getRefundReqNo());
            sb.append("&REFUNDREQDATE=").append(request.getRefundReqDate());
            sb.append("&TRANSAMT=").append(request.getTransAmt());
            sb.append("&KEY=").append(key);
            String mac = MD5.sign(sb.toString());
            Map map = BeanUtil.beanToMap((Object)request, (boolean)false, (boolean)true);
            map.put("mac", mac);
            log.debug("\u7ffc\u652f\u4ed8\u64a4\u9500\u8bf7\u6c42\u6570\u636e[reverse]->request:\n {}", new Object[]{ThlwsBeanUtil.formatJson(map)});
            String result = HttpUtil.post((String)"https://webpaywg.bestpay.com.cn/reverse/reverse", (Map)map);
            log.debug("\u7ffc\u652f\u4ed8\u64a4\u9500\u8fd4\u56de\u6570\u636e[reverse]->response \n : {}", new Object[]{ThlwsBeanUtil.formatJson(result)});
            out = (OrderReverseResponse)JSONUtil.toBean((String)result, OrderReverseResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return out;
    }
}

