/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.core;

import cn.hutool.core.util.URLUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.thlws.payment.wechat.api.WechatMpApi;
import org.thlws.payment.wechat.entity.response.mp.MpGetIndustryResponse;
import org.thlws.payment.wechat.entity.response.mp.MpJsApiTicketResponse;
import org.thlws.payment.wechat.entity.response.mp.MpOauthTokenResponse;
import org.thlws.payment.wechat.entity.response.mp.MpSendDataResponse;
import org.thlws.payment.wechat.entity.response.mp.MpSetIndustryResponse;
import org.thlws.payment.wechat.entity.response.mp.MpTemplateResponse;
import org.thlws.payment.wechat.entity.response.mp.MpTokenResponse;
import org.thlws.payment.wechat.entity.response.mp.MpUserInfoResponse;
import org.thlws.utils.ConnUtil;
import org.thlws.utils.ThlwsBeanUtil;

public class WechatMpCore
implements WechatMpApi {
    private static final Log log = LogFactory.get();

    public static MpOauthTokenResponse obtainOauthAccessToken(Map<String, Object> mapToken) throws Exception {
        MpOauthTokenResponse resp;
        String params = ThlwsBeanUtil.mapToParams(mapToken);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/oauth2/access_token");
        sb.append("?").append(params);
        System.out.print(sb.toString());
        try {
            resp = ThlwsBeanUtil.jsonToBean(ConnUtil.connURL(sb.toString()), MpOauthTokenResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return resp;
    }

    public static MpOauthTokenResponse refreshOauthAccessToken(Map<String, Object> mapToken) throws Exception {
        MpOauthTokenResponse resp;
        String params = ThlwsBeanUtil.mapToParams(mapToken);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/oauth2/refresh_token");
        sb.append("?").append(params);
        try {
            resp = ThlwsBeanUtil.jsonToBean(ConnUtil.connURL(sb.toString()), MpOauthTokenResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return resp;
    }

    public static String generateWechatUrl(String appId, String scope, String callback, String bizData) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://open.weixin.qq.com/connect/oauth2/authorize?");
        sb.append("appid=").append(appId);
        sb.append("&redirect_uri=").append(URLUtil.encode((String)callback)).append("&response_type=code&");
        sb.append("scope=").append(scope);
        sb.append("&state=").append(bizData).append("#wechat_redirect");
        return sb.toString();
    }

    public static MpUserInfoResponse obtainUserInfo(Map<String, Object> userInfoMap) throws Exception {
        MpUserInfoResponse resp;
        String params = ThlwsBeanUtil.mapToParams(userInfoMap);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/userinfo");
        sb.append("?").append(params);
        try {
            String json = ConnUtil.connURL(sb.toString());
            resp = ThlwsBeanUtil.jsonToBean(json, MpUserInfoResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return resp;
    }

    public static boolean isvalidOauthAccessToken(Map<String, Object> mapToken) throws Exception {
        boolean flag = false;
        String params = ThlwsBeanUtil.mapToParams(mapToken);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/auth");
        sb.append("?").append(params);
        try {
            String result = ConnUtil.connURL(sb.toString());
            JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
            long wCode = jsonObject.get("errcode").getAsLong();
            if (wCode == 0L) {
                flag = true;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return flag;
    }

    public static MpTokenResponse obtainAccessToken(String appid, String secret) throws Exception {
        MpTokenResponse resp;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://api.weixin.qq.com/cgi-bin/token").append("?");
            sb.append("grant_type=client_credential").append("&").append("appid=").append(appid).append("&").append("secret=").append(secret);
            String json = ConnUtil.connURL(sb.toString());
            resp = ThlwsBeanUtil.jsonToBean(json, MpTokenResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return resp;
    }

    public static MpJsApiTicketResponse obtainJsApiTicket(String token) throws Exception {
        MpJsApiTicketResponse resp;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("https://api.weixin.qq.com/cgi-bin/ticket/getticket").append("?");
            sb.append("access_token=").append(token).append("&type=jsapi");
            String json = ConnUtil.connURL(sb.toString());
            resp = ThlwsBeanUtil.jsonToBean(json, MpJsApiTicketResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return resp;
    }

    public static MpJsApiTicketResponse obtainJsApiTicket(String appid, String secret) throws Exception {
        MpTokenResponse tokenResp = WechatMpCore.obtainAccessToken(appid, secret);
        String token = tokenResp.getAccess_token();
        MpJsApiTicketResponse resp = WechatMpCore.obtainJsApiTicket(token);
        return resp;
    }

    public static MpTemplateResponse obtainTemplateId(String accessToken, String templateIdShort) throws Exception {
        MpTemplateResponse response;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://api.weixin.qq.com/cgi-bin/template/api_add_template");
            sb.append("?access_token=");
            sb.append(accessToken);
            HashMap<String, String> mapData = new HashMap<String, String>();
            mapData.put("template_id_short", templateIdShort);
            String result = ConnUtil.connRemoteWithJson(ThlwsBeanUtil.beanToJson(mapData), sb.toString());
            response = ThlwsBeanUtil.jsonToBean(result, MpTemplateResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static MpSetIndustryResponse setupIndustry(String accessToken, String industryId1, String industryId2) throws Exception {
        MpSetIndustryResponse response;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("https://api.weixin.qq.com/cgi-bin/template/api_set_industry");
            sb.append("?access_token=");
            sb.append(accessToken);
            HashMap<String, String> mapData = new HashMap<String, String>();
            mapData.put("industry_id1", industryId1);
            mapData.put("industry_id2", industryId2);
            String result = ConnUtil.connRemoteWithJson(ThlwsBeanUtil.beanToJson(mapData), sb.toString());
            log.debug("setupIndustry result={}", new Object[]{result});
            response = ThlwsBeanUtil.jsonToBean(result, MpSetIndustryResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static MpGetIndustryResponse getIndustry(String accessToken) throws Exception {
        MpGetIndustryResponse response;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("https://api.weixin.qq.com/cgi-bin/template/get_industry");
            sb.append("?access_token=");
            sb.append(accessToken);
            String result = ConnUtil.connURL(sb.toString());
            log.debug("getupIndustry result={}", new Object[]{result});
            response = ThlwsBeanUtil.jsonToBean(result, MpGetIndustryResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static MpSendDataResponse sendMsgToUser(String accessToken, String data) throws Exception {
        MpSendDataResponse response;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("https://api.weixin.qq.com/cgi-bin/message/template/send");
            sb.append("?access_token=");
            sb.append(accessToken);
            String result = ConnUtil.connRemoteWithJson(data, sb.toString());
            response = ThlwsBeanUtil.jsonToBean(result, MpSendDataResponse.class);
            log.debug("send data result:{}", new Object[]{result});
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static boolean isFromWechat(HttpServletRequest request) {
        String version;
        Pattern p;
        Matcher m;
        String userAgent = request.getHeader("User-Agent");
        return StringUtils.isNotBlank((String)userAgent) && (m = (p = Pattern.compile("MicroMessenger/(\\d+).+")).matcher(userAgent)).find() && null != (version = m.group(1)) && NumberUtils.toInt((String)version) >= 5;
    }
}

