/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.core;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import org.thlws.payment.wechat.api.WechatPayApi;
import org.thlws.payment.wechat.entity.request.CloseOrderRequest;
import org.thlws.payment.wechat.entity.request.MicroMchRequest;
import org.thlws.payment.wechat.entity.request.OpenidQueryRequest;
import org.thlws.payment.wechat.entity.request.OrderQueryRequest;
import org.thlws.payment.wechat.entity.request.UnifiedOrderRequest;
import org.thlws.payment.wechat.entity.request.WechatPayRequest;
import org.thlws.payment.wechat.entity.request.WechatRefundRequest;
import org.thlws.payment.wechat.entity.request.WechatReverseRequest;
import org.thlws.payment.wechat.entity.response.CloseOrderResponse;
import org.thlws.payment.wechat.entity.response.MicroMchResponse;
import org.thlws.payment.wechat.entity.response.OpenidQueryResponse;
import org.thlws.payment.wechat.entity.response.OrderQueryResponse;
import org.thlws.payment.wechat.entity.response.UnifiedOrderResponse;
import org.thlws.payment.wechat.entity.response.WechatPayResponse;
import org.thlws.payment.wechat.entity.response.WechatRefundResponse;
import org.thlws.payment.wechat.entity.response.WechatReverseResponse;
import org.thlws.payment.wechat.utils.WechatUtil;
import org.thlws.utils.ConnUtil;
import org.thlws.utils.ThlwsBeanUtil;

public class WechatPayCore
implements WechatPayApi {
    private static final Log log = LogFactory.get();

    public static UnifiedOrderResponse unifiedOrder(UnifiedOrderRequest request, String apiKey) throws Exception {
        UnifiedOrderResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, UnifiedOrderRequest.class, apiKey);
            log.debug("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42\u6570\u636e[unifiedorder]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/unifiedorder");
            log.debug("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8fd4\u56de\u6570\u636e[unifiedorder]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, UnifiedOrderResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static WechatRefundResponse refund(WechatRefundRequest request, String apiKey, String p12FilePath) throws Exception {
        WechatRefundResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, WechatRefundRequest.class, apiKey);
            log.debug("\u5fae\u4fe1\u9000\u6b3e\u8bf7\u6c42\u6570\u636e[refund]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/pay/refund", request.getMchId(), p12FilePath);
            log.debug("\u5fae\u4fe1\u9000\u6b3e\u54cd\u5e94\u6570\u636e[refund]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, WechatRefundResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static OrderQueryResponse orderQuery(OrderQueryRequest request, String apiKey) throws Exception {
        OrderQueryResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, OrderQueryRequest.class, apiKey);
            log.debug("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u8bf7\u6c42\u6570\u636e[orderQuery]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/orderquery");
            log.debug("\u5fae\u4fe1\u8ba2\u5355\u67e5\u8be2\u54cd\u5e94\u6570\u636e[orderQuery]->response xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, OrderQueryResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static WechatReverseResponse reverse(WechatReverseRequest request, String apiKey, String p12FilePath) throws Exception {
        WechatReverseResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, WechatReverseRequest.class, apiKey);
            log.debug("\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355\u8bf7\u6c42\u6570\u636e[reverse]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/pay/reverse", request.getMchId(), p12FilePath);
            log.debug("\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355\u54cd\u5e94\u6570\u636e[reverse]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, WechatReverseResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static CloseOrderResponse closeOrder(CloseOrderRequest request, String apiKey) throws Exception {
        CloseOrderResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, CloseOrderRequest.class, apiKey);
            log.debug("\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355\u8bf7\u6c42\u6570\u636e[closeOrder]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/closeorder");
            log.debug("\u5fae\u4fe1\u5173\u95ed\u8ba2\u5355\u54cd\u5e94\u6570\u636e[closeOrder]->xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, CloseOrderResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static WechatPayResponse microPay(WechatPayRequest request, String apiKey) throws Exception {
        WechatPayResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, WechatPayRequest.class, apiKey);
            log.debug("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\u6570\u636e[micropay]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, "https://api.mch.weixin.qq.com/pay/micropay");
            log.debug("\u5fae\u4fe1\u652f\u4ed8\u54cd\u5e94\u6570\u636e[micropay]->response xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, WechatPayResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static OpenidQueryResponse openidQuery(OpenidQueryRequest request, String apiKey) throws Exception {
        OpenidQueryResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, OpenidQueryRequest.class, apiKey);
            log.debug("\u67e5\u8be2\u7528\u6237openid[openidQuery]->xmlRequest:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.connRemoteWithXml(xml, " https://api.mch.weixin.qq.com/tools/authcodetoopenid");
            log.debug("\u67e5\u8be2\u7528\u6237openid[openidQuery]->response xmlResponse:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, OpenidQueryResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static MicroMchResponse postMicroMch(MicroMchRequest request, String apiKey, String p12FilePath) throws Exception {
        MicroMchResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, MicroMchRequest.class, apiKey);
            log.debug("\u7533\u8bf7\u5c0f\u5fae\u6536\u6b3e\u8bc6\u522b\u7801 [submchmanage] xml request:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/mch/submchmanage?action=add", request.getMchId(), p12FilePath);
            log.debug("\u7533\u8bf7\u5c0f\u5fae\u6536\u6b3e\u8bc6\u522b\u7801 [submchmanage] xml response:\n {}", new Object[]{ThlwsBeanUtil.formatXml(xmlResponse)});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, MicroMchResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }

    public static MicroMchResponse queryMicroMch(MicroMchRequest request, String apiKey, String p12FilePath) throws Exception {
        MicroMchResponse response;
        try {
            String xml = WechatUtil.buildXmlRequest(request, MicroMchRequest.class, apiKey);
            log.debug("\u67e5\u8be2\u5c0f\u5fae\u6536\u6b3e\u4eba\u8d44\u6599[submchmanage?action=query] xml request:\n {}", new Object[]{xml});
            String xmlResponse = ConnUtil.encryptPost(xml, "https://api.mch.weixin.qq.com/secapi/mch/submchmanage?action=query", request.getMchId(), p12FilePath);
            log.debug("\u67e5\u8be2\u5c0f\u5fae\u6536\u6b3e\u4eba\u8d44\u6599[submchmanage?action=query] xml response:\n {}", new Object[]{xmlResponse});
            response = ThlwsBeanUtil.xmlToBean(xmlResponse, MicroMchResponse.class);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return response;
    }
}

