/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.utils;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.XmlUtil;
import java.io.BufferedReader;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import org.thlws.payment.wechat.entity.dto.MpPayment;
import org.thlws.payment.wechat.entity.dto.MpTicket;
import org.thlws.payment.wechat.entity.response.NotifyResponse;
import org.thlws.payment.wechat.entity.response.UnifiedOrderResponse;
import org.thlws.utils.ThlwsBeanUtil;

public class WechatUtil {
    public static String sign(Map<String, Object> params, String key) {
        String prestr = ThlwsBeanUtil.createLinkString(params);
        prestr = prestr + "&key=" + key;
        return ThlwsBeanUtil.getMD5(prestr).toUpperCase();
    }

    public static String sign(MpPayment mPayment, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", mPayment.getAppId());
        params.put("timeStamp", mPayment.getTimeStamp());
        params.put("nonceStr", mPayment.getNonceStr());
        params.put("package", mPayment.getPackageStr());
        params.put("signType", "MD5");
        return WechatUtil.sign(params, key);
    }

    public static MpTicket jsTicketSign(String appId, String ticket, String url) throws Exception {
        String nonce_str = IdUtil.fastSimpleUUID();
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        String string1 = "jsapi_ticket=" + ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;
        MessageDigest crypt = MessageDigest.getInstance("SHA-1");
        crypt.reset();
        crypt.update(string1.getBytes("UTF-8"));
        String signature = WechatUtil.byteToHex(crypt.digest());
        MpTicket mpTicket = new MpTicket();
        mpTicket.setAppId(appId);
        mpTicket.setNonceStr(nonce_str);
        mpTicket.setSignature(signature);
        mpTicket.setTimestamp(timestamp);
        return mpTicket;
    }

    private static String byteToHex(byte[] hash) {
        try (Formatter formatter = new Formatter();){
            for (byte b : hash) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static NotifyResponse parseNotifyMsgToBean(String xmlResult) throws JAXBException {
        NotifyResponse response = ThlwsBeanUtil.xmlToBean(xmlResult, NotifyResponse.class);
        return response;
    }

    public static NotifyResponse parseNotifyMsgToBean(HttpServletRequest request) throws Exception {
        return WechatUtil.parseNotifyMsgToBean(WechatUtil.parseNotifyMsgToXml(request));
    }

    public static String parseNotifyMsgToXml(HttpServletRequest request) throws Exception {
        StringBuffer notifyResult = new StringBuffer();
        try (BufferedReader reader = request.getReader();){
            String inputLine = "";
            while ((inputLine = reader.readLine()) != null) {
                notifyResult.append(inputLine);
            }
        }
        return notifyResult.toString();
    }

    public static Object buildRequest(Object o, Class clz, String apiKey) {
        Map<String, Object> mapData = ThlwsBeanUtil.objectToMap(o);
        String sign = WechatUtil.sign(mapData, apiKey);
        mapData.put("sign", sign);
        return ThlwsBeanUtil.mapToObject(mapData, clz);
    }

    public static String buildXmlRequest(Object o, Class clz, String apiKey) throws JAXBException {
        String originXml = ThlwsBeanUtil.beanToXml(clz, o);
        Map map = XmlUtil.xmlToMap((String)originXml);
        String sign = WechatUtil.sign(map, apiKey);
        map.put("sign", sign);
        String xml = XmlUtil.mapToXmlStr((Map)map, (String)"xml");
        return xml;
    }

    public static void h5_pay(HttpServletRequest request, UnifiedOrderResponse response, String outTradeNo, String apiKey) {
        long time = System.currentTimeMillis() / 1000L;
        String timeStamp = String.valueOf(time);
        String appId = response.getAppId();
        String nonceStr = response.getNonceStr();
        String _package = "prepay_id=" + response.getPrepayId();
        HashMap<String, Object> sParam = new HashMap<String, Object>();
        sParam.put("appId", appId);
        sParam.put("timeStamp", timeStamp);
        sParam.put("nonceStr", nonceStr);
        sParam.put("package", _package);
        sParam.put("signType", "MD5");
        String paySign = WechatUtil.sign(sParam, apiKey);
        request.setAttribute("appId", (Object)appId);
        request.setAttribute("timeStamp", (Object)timeStamp);
        request.setAttribute("nonceStr", (Object)nonceStr);
        request.setAttribute("packageStr", (Object)_package);
        request.setAttribute("signType", (Object)"MD5");
        request.setAttribute("paySign", (Object)paySign);
        request.setAttribute("outTradeNo", (Object)outTradeNo);
    }
}

