/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ThlwsBeanUtil {
    public static Map<String, Object> objectToMap(Object o) {
        Map map = BeanUtil.beanToMap((Object)o, (boolean)false, (boolean)true);
        return map;
    }

    public static Map<String, Object> dataFilter(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map == null || map.size() <= 0) {
            return result;
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null || value.equals("")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, Object> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = params.get(key);
            if (i == keys.size() - 1) {
                sb.append(key).append("=").append(value);
                continue;
            }
            sb.append(key).append("=").append(value).append("&");
        }
        return sb.toString();
    }

    public static String mapToParams(Map<String, Object> mapData) {
        StringBuffer sb = new StringBuffer();
        if (mapData.isEmpty()) {
            return "";
        }
        for (String key : mapData.keySet()) {
            String value = (String)mapData.get(key);
            if (sb.length() < 1) {
                sb.append(key).append("=").append(value);
                continue;
            }
            sb.append("&").append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) {
        Object obj = BeanUtil.mapToBean(map, beanClass, (boolean)true);
        return obj;
    }

    public static String getMD5(String data) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] source = data.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source);
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String formatXml(String xml) throws Exception {
        Document document = DocumentHelper.parseText((String)xml);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
        xmlWriter.write(document);
        xmlWriter.close();
        return writer.toString();
    }

    public static String beanToXml(Class clazz, Object bean) throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)true);
        marshaller.marshal(bean, (Writer)writer);
        return writer.toString();
    }

    public static <T> T xmlToBean(String xml, Class<T> cls) throws JAXBException {
        StringReader reader = new StringReader(xml);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{cls});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (T)unmarshaller.unmarshal((Reader)reader);
    }

    public static String formatJson(Object o) {
        return JSONUtil.parse((Object)o).toStringPretty();
    }

    public static String formatJson(String jsonStr) {
        return JSONUtil.formatJsonStr((String)jsonStr);
    }

    public static <T> T jsonToBean(String json, Class<T> cls) {
        Gson gson = new Gson();
        Object t = gson.fromJson(json, cls);
        return (T)t;
    }

    public static String beanToJson(Object o) {
        Gson gson = new Gson();
        String json = gson.toJson(o);
        return json;
    }
}

