/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.portal.official;

import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.thlws.payment.wechat.api.WechatApi;
import org.thlws.payment.wechat.entity.output.IndustryOutput;
import org.thlws.payment.wechat.entity.output.JsApiTicketOutput;
import org.thlws.payment.wechat.entity.output.OauthTokenOutput;
import org.thlws.payment.wechat.entity.output.SendDataOutput;
import org.thlws.payment.wechat.entity.output.TemplateOutput;
import org.thlws.payment.wechat.entity.output.TokenOutput;
import org.thlws.payment.wechat.entity.output.UserInfoOutput;
import org.thlws.payment.wechat.utils.ConnUtil;
import org.thlws.payment.wechat.utils.ThlwsBeanUtil;

public class WechatOfficial
implements WechatApi {
    private static final Log log = LogFactory.get();

    public static OauthTokenOutput obtainOauthAccessToken(Map<String, Object> mapToken) {
        OauthTokenOutput resp = new OauthTokenOutput();
        String params = ThlwsBeanUtil.mapToParams(mapToken);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/oauth2/access_token");
        sb.append("?").append(params);
        System.out.print(sb.toString());
        try {
            String jr = ConnUtil.connURL(sb.toString());
            System.out.println("\n\n*****************************");
            System.out.println("\u5fae\u4fe1\u53d6OpenId resp=" + jr);
            System.out.println("\n\n*****************************");
            Gson gson = new Gson();
            resp = (OauthTokenOutput)gson.fromJson(jr, OauthTokenOutput.class);
        }
        catch (Exception e) {
            resp.setDesc(e.getMessage());
            log.error("obtainOauthAccessToken error:{}", new Object[]{e.getMessage()});
        }
        return resp;
    }

    public static OauthTokenOutput refreshOauthAccessToken(Map<String, Object> mapToken) {
        OauthTokenOutput resp = new OauthTokenOutput();
        String params = ThlwsBeanUtil.mapToParams(mapToken);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/oauth2/refresh_token");
        sb.append("?").append(params);
        try {
            String jr = ConnUtil.connURL(sb.toString());
            Gson gson = new Gson();
            resp = (OauthTokenOutput)gson.fromJson(jr, OauthTokenOutput.class);
        }
        catch (Exception e) {
            resp.setDesc(e.getMessage());
            log.error("refreshOauthAccessToken error:{}", new Object[]{e.getMessage()});
        }
        return resp;
    }

    public static String generateWechatUrl(String appId, String scope, String callback, String bizData) {
        AtomicReference<StringBuilder> sb = new AtomicReference<StringBuilder>(new StringBuilder());
        sb.get().append("https://open.weixin.qq.com/connect/oauth2/authorize?");
        sb.get().append("appid=").append(appId);
        sb.get().append("&redirect_uri=").append(callback).append("&response_type=code&");
        sb.get().append("scope=").append(scope);
        sb.get().append("&state=").append(bizData).append("#wechat_redirect");
        return sb.get().toString();
    }

    public static UserInfoOutput obtainUserInfo(Map<String, Object> userInfoMap) {
        UserInfoOutput resp = new UserInfoOutput();
        String params = ThlwsBeanUtil.mapToParams(userInfoMap);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/userinfo");
        sb.append("?").append(params);
        try {
            String jr = ConnUtil.connURL(sb.toString());
            Gson gson = new Gson();
            resp = (UserInfoOutput)gson.fromJson(jr, UserInfoOutput.class);
        }
        catch (Exception e) {
            resp.setDesc(e.getMessage());
            log.error("obtainUserInfo error:{}", new Object[]{e.getMessage()});
        }
        return resp;
    }

    public static boolean IsvalidOauthAccessToken(Map<String, Object> mapToken) {
        boolean flag = false;
        String params = ThlwsBeanUtil.mapToParams(mapToken);
        StringBuilder sb = new StringBuilder("https://api.weixin.qq.com/sns/auth");
        sb.append("?").append(params);
        try {
            String result = ConnUtil.connURL(sb.toString());
            Gson gson = new Gson();
            JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
            long wCode = jsonObject.get("errcode").getAsLong();
            if (wCode == 0L) {
                flag = true;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return flag;
    }

    public static TokenOutput obtainAccessToken(String appid, String secret) {
        TokenOutput resp = new TokenOutput();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://api.weixin.qq.com/cgi-bin/token").append("?");
            sb.append("grant_type=client_credential").append("&").append("appid=").append(appid).append("&").append("secret=").append(secret);
            String jr = ConnUtil.connURL(sb.toString());
            Gson gson = new Gson();
            resp = (TokenOutput)gson.fromJson(jr, TokenOutput.class);
        }
        catch (Exception e) {
            resp.setDesc(e.getMessage());
            log.error("obtainAccessToken error:{}", new Object[]{e.getMessage()});
        }
        return resp;
    }

    public static JsApiTicketOutput obtainJsApiTicket(String token) {
        JsApiTicketOutput resp = new JsApiTicketOutput();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("https://api.weixin.qq.com/cgi-bin/ticket/getticket").append("?");
            sb.append("access_token=").append(token).append("&type=jsapi");
            String jr = ConnUtil.connURL(sb.toString());
            Gson gson = new Gson();
            resp = (JsApiTicketOutput)gson.fromJson(jr, JsApiTicketOutput.class);
        }
        catch (Exception e) {
            resp.setDesc(e.getMessage());
            log.error("obtainJsApiTicket error:{}", new Object[]{e.getMessage()});
        }
        return resp;
    }

    public static JsApiTicketOutput obtainJsApiTicket(String appid, String secret) {
        TokenOutput tokenResp = WechatOfficial.obtainAccessToken(appid, secret);
        String token = tokenResp.getAccess_token();
        JsApiTicketOutput resp = WechatOfficial.obtainJsApiTicket(token);
        return resp;
    }

    public static TemplateOutput obtainTemplateId(String access_token, String template_id_short) {
        TemplateOutput output = new TemplateOutput();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://api.weixin.qq.com/cgi-bin/template/api_add_template");
            sb.append("?access_token=");
            sb.append(access_token);
            HashMap<String, String> mapData = new HashMap<String, String>();
            mapData.put("template_id_short", template_id_short);
            Gson gson = new Gson();
            String json = gson.toJson(mapData);
            String result = ConnUtil.connRemoteWithJson(json, sb.toString());
            output = (TemplateOutput)gson.fromJson(result, TemplateOutput.class);
        }
        catch (Exception e) {
            output.setDesc(e.getMessage());
            log.error("obtainTemplateId error:{}", new Object[]{e.getMessage()});
        }
        return output;
    }

    public static IndustryOutput setupIndustry(String access_token, String industry_id1, String industry_id2) {
        IndustryOutput output = new IndustryOutput();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("https://api.weixin.qq.com/cgi-bin/template/api_set_industry");
            sb.append("?access_token=");
            sb.append(access_token);
            HashMap<String, String> mapData = new HashMap<String, String>();
            mapData.put("industry_id1", industry_id1);
            mapData.put("industry_id2", industry_id2);
            Gson gson = new Gson();
            String json = gson.toJson(mapData);
            String result = ConnUtil.connRemoteWithJson(json, sb.toString());
            log.info("setupIndustry result={}", new Object[]{result});
            output = (IndustryOutput)gson.fromJson(result, IndustryOutput.class);
        }
        catch (Exception e) {
            output.setDesc(e.getMessage());
            log.error("setupIndustry error:{}", new Object[]{e.getMessage()});
        }
        return output;
    }

    public static SendDataOutput sendData2wechat(String access_token, String data) {
        SendDataOutput output = new SendDataOutput();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("https://api.weixin.qq.com/cgi-bin/message/template/send");
            sb.append("?access_token=");
            sb.append(access_token);
            String result = ConnUtil.connRemoteWithJson(data, sb.toString());
            Gson gson = new Gson();
            output = (SendDataOutput)gson.fromJson(result, SendDataOutput.class);
            log.info("send data result:{}", new Object[]{result});
        }
        catch (Exception e) {
            output.setDesc(e.getMessage());
            log.error("sendData2wechat error:{}", new Object[]{e.getMessage()});
        }
        return output;
    }
}

