/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.http.ssl.SSLSocketFactoryBuilder;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocketFactory;

public final class ConnUtil {
    private static final Log log = LogFactory.get();
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECTION_REQUEST_TIMEOUT = 30000;

    public static String connRemote(String request, String url) throws Exception {
        String result = "";
        try {
            result = ConnUtil.connRemoteWithJson(result, url);
        }
        catch (Exception e) {
            log.error("connRemote error: {}", new Object[]{e.getMessage()});
            throw new Exception(e.getMessage());
        }
        return result;
    }

    public static String connRemoteWithJson(String json, String url) throws Exception {
        String result = "";
        try {
            result = HttpUtil.createRequest((Method)Method.POST, (String)url).body(json, "application/json;charset=UTF-8").execute().body();
        }
        catch (Exception e) {
            log.error("connRemoteWithJson error:{} ", new Object[]{e.getMessage()});
            throw new Exception(e.getMessage());
        }
        return result;
    }

    public static String connRemoteWithXml(String xml, String url) throws Exception {
        String result;
        try {
            result = HttpUtil.createRequest((Method)Method.POST, (String)url).body(xml, "text/xml;charset=UTF-8").execute().body();
        }
        catch (Exception e) {
            log.error("connRemoteWithXml error: {}", new Object[]{e.getMessage()});
            throw new Exception(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptPost(String data, String url, String pwd, String absoluteFile) {
        String result;
        log.info("\u8bf7\u6c42\u7f51\u5173\uff1a" + url, new Object[0]);
        log.info("\u8bc1\u4e66\u53f7\uff1a" + pwd, new Object[0]);
        log.info("p12\u672c\u5730\u6587\u4ef6\u4fdd\u5b58\u5730\u5740\uff1a" + absoluteFile, new Object[0]);
        try {
            File p12File = new File(absoluteFile);
            if (!p12File.exists()) {
                log.error("p12\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u8def\u5f84\u4e0b\u662f\u5426\u5b58\u5728p12:" + absoluteFile, new Object[0]);
                throw new Exception("p12\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u8def\u5f84\u4e0b\u662f\u5426\u5b58\u5728p12:" + absoluteFile);
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream instream = new FileInputStream(new File(absoluteFile));){
                keyStore.load(instream, pwd.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, pwd.toCharArray());
            KeyManager[] keyManagers = kmf.getKeyManagers();
            SSLSocketFactoryBuilder sslBuilder = SSLSocketFactoryBuilder.create();
            SSLSocketFactory ssf = sslBuilder.setKeyManagers(keyManagers).build();
            result = HttpRequest.post((String)url).body(data, "text/xml;charset=UTF-8").setSSLSocketFactory(ssf).execute().body();
        }
        catch (Exception e) {
            result = e.getMessage();
            log.error("encryptPost error:{}", new Object[]{e.getMessage()});
        }
        return result;
    }

    public static String connURL(String url) throws Exception {
        String result;
        try {
            result = HttpUtil.get((String)url);
        }
        catch (Exception e) {
            log.error("connURL error:{} ", new Object[]{e.getMessage()});
            throw new Exception(e.getMessage());
        }
        return result;
    }
}

