/*
 * Decompiled with CFR 0.152.
 */
package org.thlws.payment.wechat.utils;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.thlws.payment.wechat.entity.output.NotifyOutput;
import org.thlws.payment.wechat.entity.output.UnifiedOrderOutput;
import org.thlws.payment.wechat.extra.xml.XStreamCreator;
import org.thlws.payment.wechat.utils.ThlwsBeanUtil;

public class WechatUtil {
    public static String sign(Map<String, Object> params, String key) {
        String prestr = ThlwsBeanUtil.createLinkString(params);
        prestr = prestr + "&key=" + key;
        String mysign = ThlwsBeanUtil.getMD5(prestr).toUpperCase();
        return mysign;
    }

    public static NotifyOutput parseNotifyMsg(String xmlResult) {
        XStream xStream = XStreamCreator.create(NotifyOutput.class);
        NotifyOutput output = (NotifyOutput)xStream.fromXML(xmlResult);
        return output;
    }

    public static Object buildRequest(Object o, Class clz, String apiKey) {
        Map<String, Object> mapData = ThlwsBeanUtil.ObjectToMap(o);
        String sign = WechatUtil.sign(mapData, apiKey);
        mapData.put("sign", sign);
        return ThlwsBeanUtil.mapToObject(mapData, clz);
    }

    public static void main(String[] args) {
        String notifyXmlResult = "<xml><appid><![CDATA[wx5f22a16d8c94dba4]]></appid><attach><![CDATA[69a8ef0cb3c742779c438e92bbc33118]]></attach><bank_type><![CDATA[CFT]]></bank_type><cash_fee><![CDATA[1]]></cash_fee><device_info><![CDATA[hanley@1025@cust_test]]></device_info><fee_type><![CDATA[CNY]]></fee_type><is_subscribe><![CDATA[Y]]></is_subscribe><mch_id><![CDATA[1336236101]]></mch_id><nonce_str><![CDATA[txjam10ant72jxl5umsl2hbl2nrb0kzr]]></nonce_str><openid><![CDATA[o2nMlwuj_cHFBcNDfPkpufta80KU]]></openid><out_trade_no><![CDATA[20170224052028]]></out_trade_no><result_code><![CDATA[SUCCESS]]></result_code><return_code><![CDATA[SUCCESS]]></return_code><sign><![CDATA[D8D69790FB5416AF86070B4DAD673E89]]></sign><time_end><![CDATA[20170224052134]]></time_end><total_fee>1</total_fee><trade_type><![CDATA[JSAPI]]></trade_type><transaction_id><![CDATA[4005332001201702241084568187]]></transaction_id></xml>";
        WechatUtil.parseNotifyMsg(notifyXmlResult);
    }

    public static void h5_pay(HttpServletRequest request, UnifiedOrderOutput output, String outTradeNo, String apiKey) {
        long time = System.currentTimeMillis() / 1000L;
        String timeStamp = String.valueOf(time);
        String appId = output.getAppid();
        String nonceStr = output.getNonce_str();
        String _package = "prepay_id=" + output.getPrepay_id();
        HashMap<String, Object> sParam = new HashMap<String, Object>();
        sParam.put("appId", appId);
        sParam.put("timeStamp", timeStamp);
        sParam.put("nonceStr", nonceStr);
        sParam.put("package", _package);
        sParam.put("signType", "MD5");
        String paySign = WechatUtil.sign(sParam, apiKey);
        request.setAttribute("appId", (Object)appId);
        request.setAttribute("timeStamp", (Object)timeStamp);
        request.setAttribute("nonceStr", (Object)nonceStr);
        request.setAttribute("packageStr", (Object)_package);
        request.setAttribute("signType", (Object)"MD5");
        request.setAttribute("paySign", (Object)paySign);
        request.setAttribute("outTradeNo", (Object)outTradeNo);
    }
}

