/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.toml;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class MoreTypes {
    static TypeSerializerCollection getTypeSerializers() {
        return TypeSerializerCollection.defaults().childBuilder().register(Date.class, (TypeSerializer)new DateSerializer()).register(Instant.class, (TypeSerializer)new InstantSerializer()).build();
    }

    public static @Nullable Date asDate(@Nullable Object value) {
        TemporalAccessor ta;
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof TemporalAccessor && (ta = (TemporalAccessor)value).isSupported(ChronoField.INSTANT_SECONDS)) {
            long millis = (long)ta.get(ChronoField.INSTANT_SECONDS) * 1000L;
            if (ta.isSupported(ChronoField.MILLI_OF_SECOND)) {
                millis += (long)ta.get(ChronoField.MILLI_OF_SECOND);
            }
            return new Date(millis);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String dateString = value.toString();
        try {
            return DateFormat.getInstance().parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static @Nullable Date strictAsDate(@Nullable Object value) {
        return value == null ? null : (value instanceof Date ? (Date)value : null);
    }

    public static @Nullable Instant asInstant(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Date) {
            return Instant.ofEpochMilli(((Date)value).getTime());
        }
        if (value instanceof TemporalAccessor) {
            try {
                return Instant.from((TemporalAccessor)value);
            }
            catch (DateTimeException e) {
                return null;
            }
        }
        String instantString = value.toString();
        try {
            return Instant.parse(instantString);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static @Nullable Instant strictAsInstant(@Nullable Object value) {
        return value == null ? null : (value instanceof Instant ? (Instant)value : null);
    }

    private static class DateSerializer
    implements TypeSerializer<Date> {
        private DateSerializer() {
        }

        public Date deserialize(Type type, ConfigurationNode node) throws SerializationException {
            @Nullable Date date = MoreTypes.asDate(node.raw());
            return date != null ? date : Date.from(Instant.EPOCH);
        }

        public void serialize(Type type, @Nullable Date obj, ConfigurationNode node) throws SerializationException {
            node.set(type, (Object)obj);
        }
    }

    private static class InstantSerializer
    implements TypeSerializer<Instant> {
        private InstantSerializer() {
        }

        public Instant deserialize(Type type, ConfigurationNode node) throws SerializationException {
            @Nullable Instant instant = MoreTypes.asInstant(node.raw());
            return instant != null ? instant : Instant.EPOCH;
        }

        public void serialize(Type type, @Nullable Instant obj, ConfigurationNode node) throws SerializationException {
            node.set(type, (Object)obj);
        }
    }
}

