/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.SettableListenableFuture;
import org.threadly.load.ErrorStepResult;
import org.threadly.load.ExecutableScript;
import org.threadly.load.MaintenanceErrorStepResult;
import org.threadly.load.MaintenancePassStepResult;
import org.threadly.load.ParallelScriptBuilder;
import org.threadly.load.PassStepResult;
import org.threadly.load.ScriptStep;
import org.threadly.load.SequentialScriptBuilder;
import org.threadly.load.StepResult;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionUtils;

public abstract class AbstractScriptBuilder {
    private int neededThreadCount = 1;
    private Exception replacementException = null;

    protected AbstractScriptBuilder() {
    }

    public ListenableFuture<Double> addProgressFuture() {
        SettableListenableFuture slf = new SettableListenableFuture(false);
        this.addStep(new ProgressScriptStep((SettableListenableFuture<Double>)slf));
        return slf;
    }

    public void setMaxScriptStepRate(double stepsPerSecondLimit) {
        this.addStep(new RateAdjustmentStep(stepsPerSecondLimit));
    }

    public abstract boolean hasSteps();

    public abstract void addStep(ScriptStep var1);

    protected abstract void addStep(ExecutableScript.ExecutionItem var1);

    public abstract void addSteps(SequentialScriptBuilder var1);

    public abstract void addSteps(ParallelScriptBuilder var1);

    public void addSteps(AbstractScriptBuilder scriptBuilder) {
        if (scriptBuilder == null) {
            return;
        }
        if (scriptBuilder instanceof SequentialScriptBuilder) {
            this.addSteps((SequentialScriptBuilder)scriptBuilder);
        } else if (scriptBuilder instanceof ParallelScriptBuilder) {
            this.addSteps((ParallelScriptBuilder)scriptBuilder);
        } else {
            throw new UnsupportedOperationException("Provided an unknown builder type: " + scriptBuilder.getClass());
        }
    }

    public int getMaximumNeededThreadCount() {
        return this.neededThreadCount;
    }

    public abstract AbstractScriptBuilder makeCopy();

    protected void maybeUpdatedMaximumThreads(int currentValue) {
        if (this.neededThreadCount < currentValue) {
            this.neededThreadCount = currentValue;
        }
    }

    protected abstract ExecutableScript.ExecutionItem getStepAsExecutionItem();

    protected abstract void setStartHandlerOnAllSteps(ExecutableScript.ExecutionItem.StepStartHandler var1);

    protected static void setStartHandler(ExecutableScript.ExecutionItem.ChildItems items, ExecutableScript.ExecutionItem.StepStartHandler startHandler) {
        for (ExecutableScript.ExecutionItem ei : items) {
            if (ei.isChainExecutor()) {
                AbstractScriptBuilder.setStartHandler(ei.getChildItems(), startHandler);
                continue;
            }
            ei.setStartHandler(startHandler);
        }
    }

    protected void replaced() {
        this.verifyNotReplaced();
        this.replacementException = new Exception();
    }

    protected void verifyValid() {
        this.verifyNotReplaced();
    }

    protected void verifyNotReplaced() {
        if (this.replacementException != null) {
            throw new RuntimeException("This builder has been replaced, caused by exception will indicate the stack of where it was replaced", this.replacementException);
        }
    }

    public ExecutableScript build() {
        this.replaced();
        return new ExecutableScript(this.neededThreadCount, this.getStepAsExecutionItem());
    }

    protected static class ExecutionItemCompletionRunner
    implements Runnable {
        private final ExecutableScript.ExecutionItem item;

        public ExecutionItemCompletionRunner(ExecutableScript.ExecutionItem item) {
            this.item = item;
        }

        @Override
        public void run() {
            this.item.runComplete();
        }
    }

    protected static abstract class AbstractExecutionItem
    implements ExecutableScript.ExecutionItem {
        private ExecutableScript.ExecutionItem.StepStartHandler handler = null;

        protected AbstractExecutionItem() {
        }

        @Override
        public void setStartHandler(ExecutableScript.ExecutionItem.StepStartHandler handler) {
            if (this.handler != null && handler != null) {
                ExceptionUtils.handleException((Throwable)new IllegalStateException("Pre-run condition already set"));
            }
            this.handler = handler;
        }

        @Override
        public void itemReadyForExecution(ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            if (this.handler != null) {
                this.handler.readyToRun(this, assistant);
            } else {
                this.runItem(assistant);
            }
        }

        protected abstract void runItem(ExecutableScript.ExecutionItem.ExecutionAssistant var1);
    }

    protected static class ScriptStepRunner
    extends AbstractExecutionItem {
        protected ScriptStep scriptStep;
        protected SettableListenableFuture<StepResult> future;

        public ScriptStepRunner(ScriptStep scriptStep) {
            this.scriptStep = scriptStep;
            this.future = new SettableListenableFuture(false);
        }

        @Override
        public void prepareForRun() {
        }

        @Override
        public void runComplete() {
            this.scriptStep = null;
            this.future.cancel(true);
        }

        @Override
        public void itemReadyForExecution(ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            this.future.setRunningThread(Thread.currentThread());
            super.itemReadyForExecution(assistant);
        }

        @Override
        protected void runItem(ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            if (this.scriptStep == null) {
                throw new IllegalStateException("Run has completed");
            }
            if (assistant.getMarkedGlobalFailure()) {
                this.future.cancel(false);
                return;
            }
            this.future.setRunningThread(Thread.currentThread());
            switch (this.scriptStep.getStepType()) {
                case Normal: {
                    long startNanos = Clock.accurateTimeNanos();
                    try {
                        this.scriptStep.runStep();
                        long endNanos = Clock.accurateTimeNanos();
                        this.future.setResult((Object)new PassStepResult(this.scriptStep.getIdentifier(), endNanos - startNanos));
                    }
                    catch (Throwable t) {
                        long endNanos = Clock.accurateTimeNanos();
                        this.future.setResult((Object)new ErrorStepResult(this.scriptStep.getIdentifier(), endNanos - startNanos, t));
                        assistant.markGlobalFailure();
                    }
                    break;
                }
                case AsyncMaintenance: {
                    final ScriptStep fScriptStep = this.scriptStep;
                    this.future.setResult((Object)new MaintenancePassStepResult(this.scriptStep.getIdentifier()));
                    assistant.executeAsyncMaintenanceTaskIfStillRunning(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                fScriptStep.runStep();
                            }
                            catch (Throwable t) {
                                ExceptionUtils.handleException((Throwable)t);
                            }
                        }
                    });
                    break;
                }
                case Maintenance: {
                    try {
                        this.scriptStep.runStep();
                        this.future.setResult((Object)new MaintenancePassStepResult(this.scriptStep.getIdentifier()));
                    }
                    catch (Throwable t) {
                        this.future.setResult((Object)new MaintenanceErrorStepResult(this.scriptStep.getIdentifier(), t));
                        assistant.markGlobalFailure();
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        @Override
        public ScriptStepRunner makeCopy() {
            if (this.scriptStep == null) {
                throw new IllegalStateException("Run has completed");
            }
            return new ScriptStepRunner(this.scriptStep);
        }

        public List<SettableListenableFuture<StepResult>> getFutures() {
            return Collections.singletonList(this.future);
        }

        @Override
        public ExecutableScript.ExecutionItem.ChildItems getChildItems() {
            return ChildItemContainer.EMPTY_CHILD_ITEMS_CONTAINER;
        }

        public String toString() {
            return this.scriptStep == null ? "CompletedScriptStep" : this.scriptStep.getIdentifier().toString();
        }

        @Override
        public boolean manipulatesExecutionAssistant() {
            return false;
        }

        @Override
        public boolean isChainExecutor() {
            return false;
        }
    }

    protected static abstract class StepCollectionRunner
    extends AbstractExecutionItem {
        private final ArrayList<SettableListenableFuture<StepResult>> futures;
        private ExecutableScript.ExecutionItem[] steps = new ExecutableScript.ExecutionItem[0];

        public StepCollectionRunner() {
            this.futures = new ArrayList();
        }

        public int getStepCount() {
            if (this.steps == null) {
                throw new IllegalStateException("Run has completed");
            }
            return this.steps.length;
        }

        public ExecutableScript.ExecutionItem[] getSteps() {
            if (this.steps == null) {
                throw new IllegalStateException("Run has completed");
            }
            return this.steps;
        }

        protected void setSteps(ExecutableScript.ExecutionItem[] steps) {
            ArgumentVerifier.assertNotNull((Object)steps, (String)"steps");
            if (this.steps == null) {
                throw new IllegalStateException("Run has completed");
            }
            this.steps = steps;
        }

        @Override
        public void prepareForRun() {
            this.futures.trimToSize();
            for (ExecutableScript.ExecutionItem ei : this.steps) {
                ei.prepareForRun();
            }
        }

        @Override
        public void runComplete() {
            this.steps = null;
            FutureUtils.cancelIncompleteFutures(this.getFutures(), (boolean)true);
        }

        private ExecutableScript.ExecutionItem[] makeStepsCopy(int extraEndSpace) {
            ExecutableScript.ExecutionItem[] newSteps = new ExecutableScript.ExecutionItem[this.steps.length + extraEndSpace];
            System.arraycopy(this.steps, 0, newSteps, 0, this.steps.length);
            return newSteps;
        }

        public void addItem(ExecutableScript.ExecutionItem item) {
            if (this.steps == null) {
                throw new IllegalStateException("Run has completed");
            }
            this.futures.addAll(item.getFutures());
            ExecutableScript.ExecutionItem[] newSteps = this.makeStepsCopy(1);
            newSteps[this.steps.length] = item;
            this.steps = newSteps;
        }

        public void addItems(ExecutableScript.ExecutionItem[] items) {
            if (this.steps == null) {
                throw new IllegalStateException("Run has completed");
            }
            if (items.length == 0) {
                return;
            }
            for (ExecutableScript.ExecutionItem ei : items) {
                this.futures.addAll(ei.getFutures());
            }
            ExecutableScript.ExecutionItem[] newSteps = this.makeStepsCopy(items.length);
            System.arraycopy(items, 0, newSteps, this.steps.length, items.length);
            this.steps = newSteps;
        }

        @Override
        public List<? extends SettableListenableFuture<StepResult>> getFutures() {
            return this.futures;
        }

        public String toString() {
            return this.steps == null ? "CompletedStepCollection" : Arrays.toString(this.steps);
        }

        @Override
        public boolean manipulatesExecutionAssistant() {
            return false;
        }

        @Override
        public boolean isChainExecutor() {
            return true;
        }
    }

    protected static abstract class GhostExecutionItem
    extends AbstractExecutionItem {
        protected GhostExecutionItem() {
        }

        @Override
        public void prepareForRun() {
        }

        @Override
        public void runComplete() {
        }

        @Override
        public List<? extends SettableListenableFuture<StepResult>> getFutures() {
            return Collections.emptyList();
        }

        @Override
        public ExecutableScript.ExecutionItem makeCopy() {
            return null;
        }

        @Override
        public ExecutableScript.ExecutionItem.ChildItems getChildItems() {
            return ChildItemContainer.EMPTY_CHILD_ITEMS_CONTAINER;
        }

        @Override
        public boolean isChainExecutor() {
            return false;
        }
    }

    private static class ProgressScriptStep
    extends GhostExecutionItem {
        private final SettableListenableFuture<Double> slf;

        public ProgressScriptStep(SettableListenableFuture<Double> slf) {
            this.slf = slf;
        }

        @Override
        protected void runItem(ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            try {
                List<ListenableFuture<StepResult>> scriptFutures = assistant.getGlobalRunningFutureSet();
                double doneCount = 0.0;
                Iterator<ListenableFuture<StepResult>> it = scriptFutures.iterator();
                while (it.hasNext()) {
                    if (!it.next().isDone()) continue;
                    doneCount += 1.0;
                }
                this.slf.setResult((Object)(doneCount / (double)scriptFutures.size() * 100.0));
            }
            catch (Exception e) {
                this.slf.setFailure((Throwable)e);
            }
        }

        public String toString() {
            return ProgressScriptStep.class.getSimpleName();
        }

        @Override
        public boolean manipulatesExecutionAssistant() {
            return false;
        }
    }

    private static class RateAdjustmentStep
    extends GhostExecutionItem {
        private final double newRateLimit;

        public RateAdjustmentStep(double newRateLimit) {
            this.newRateLimit = newRateLimit;
        }

        @Override
        protected void runItem(ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            assistant.setStepPerSecondLimit(this.newRateLimit);
        }

        public String toString() {
            return "RateAdjustment:" + this.newRateLimit;
        }

        @Override
        public boolean manipulatesExecutionAssistant() {
            return true;
        }
    }

    protected static class ChildItemContainer
    implements ExecutableScript.ExecutionItem.ChildItems {
        protected static final ChildItemContainer EMPTY_CHILD_ITEMS_CONTAINER = new ChildItemContainer();
        protected final ExecutableScript.ExecutionItem[] items;
        protected final boolean runSequentially;

        private ChildItemContainer() {
            this(null, true);
        }

        protected ChildItemContainer(ExecutableScript.ExecutionItem[] items, boolean runSequentially) {
            this.items = items;
            this.runSequentially = runSequentially;
        }

        @Override
        public boolean itemsRunSequential() {
            return this.runSequentially;
        }

        @Override
        public boolean hasChildren() {
            return this.items != null && this.items.length > 0;
        }

        @Override
        public Iterator<ExecutableScript.ExecutionItem> iterator() {
            if (this.hasChildren()) {
                return Arrays.asList(this.items).iterator();
            }
            return Collections.emptyList().iterator();
        }
    }
}

