/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.threadly.concurrent.collections.ConcurrentArrayList;
import org.threadly.load.LightCharSequence;

public class CharsDeduplicator {
    private static final ConcurrentMap<Integer, ConcurrentArrayList<LightCharSequence>> CACHE = new ConcurrentHashMap<Integer, ConcurrentArrayList<LightCharSequence>>();

    public static LightCharSequence deDuplicate(String str) {
        return CharsDeduplicator.deDuplicate(str.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LightCharSequence deDuplicate(char[] chars) {
        int lastIndex;
        if (chars == null) {
            return null;
        }
        ConcurrentArrayList<LightCharSequence> deDupList = (ConcurrentArrayList<LightCharSequence>)CACHE.get(chars.length);
        if (deDupList == null) {
            deDupList = new ConcurrentArrayList();
            ConcurrentArrayList<LightCharSequence> existing = CACHE.putIfAbsent(chars.length, deDupList);
            if (existing != null) {
                deDupList = existing;
            }
        }
        for (lastIndex = 0; lastIndex < deDupList.size(); ++lastIndex) {
            LightCharSequence c = (LightCharSequence)deDupList.get(lastIndex);
            if (!Arrays.equals(c.chars, chars)) continue;
            return c;
        }
        Object object = deDupList.getModificationLock();
        synchronized (object) {
            ListIterator it = deDupList.listIterator(lastIndex);
            while (it.hasNext()) {
                LightCharSequence c = (LightCharSequence)it.next();
                if (!Arrays.equals(c.chars, chars)) continue;
                return c;
            }
            LightCharSequence result = new LightCharSequence(chars);
            deDupList.add((Object)result);
            return result;
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }
}

