/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.load.AbstractScriptBuilder;
import org.threadly.load.ExecutableScript;
import org.threadly.load.ScriptStep;
import org.threadly.load.SequentialScriptBuilder;
import org.threadly.load.StepResultCollectionUtils;
import org.threadly.util.Clock;

public class ParallelScriptBuilder
extends AbstractScriptBuilder {
    protected final ParallelStep currentStep = new ParallelStep();
    private int stepsThreadsNeeded = 0;

    @Override
    public boolean hasSteps() {
        return this.currentStep.getStepCount() > 0;
    }

    @Override
    protected ExecutableScript.ExecutionItem getStepAsExecutionItem() {
        return this.currentStep;
    }

    @Override
    protected void setStartHandlerOnAllSteps(ExecutableScript.ExecutionItem.StepStartHandler startHandler) {
        ParallelScriptBuilder.setStartHandler(this.currentStep.getChildItems(), startHandler);
    }

    @Override
    public ParallelScriptBuilder makeCopy() {
        ParallelScriptBuilder result = new ParallelScriptBuilder();
        for (ExecutableScript.ExecutionItem item : this.currentStep.getSteps()) {
            result.addStep(item.makeCopy());
        }
        return result;
    }

    @Override
    public void addStep(ScriptStep step) {
        this.addStep(step, 1);
    }

    public void addStep(ScriptStep step, int times) {
        this.verifyValid();
        this.incrementThreads(times);
        for (int i = 0; i < times; ++i) {
            this.currentStep.addItem(new AbstractScriptBuilder.ScriptStepRunner(step));
        }
    }

    @Override
    protected void addStep(ExecutableScript.ExecutionItem step) {
        this.verifyValid();
        this.currentStep.addItem(step);
    }

    private void incrementThreads(int value) {
        this.stepsThreadsNeeded += value;
        this.maybeUpdatedMaximumThreads(this.stepsThreadsNeeded);
    }

    @Override
    public void addSteps(SequentialScriptBuilder sequentialSteps) {
        this.verifyValid();
        sequentialSteps.replaced();
        if (!sequentialSteps.hasSteps()) {
            return;
        }
        this.incrementThreads(sequentialSteps.getMaximumNeededThreadCount());
        this.currentStep.addItem(sequentialSteps.currentStep);
    }

    @Override
    public void addSteps(ParallelScriptBuilder parallelSteps) {
        this.verifyValid();
        parallelSteps.replaced();
        if (!parallelSteps.hasSteps()) {
            return;
        }
        this.incrementThreads(parallelSteps.getMaximumNeededThreadCount());
        this.currentStep.addItems(parallelSteps.currentStep.getSteps());
    }

    protected static class ParallelStep
    extends AbstractScriptBuilder.StepCollectionRunner {
        protected ParallelStep() {
        }

        @Override
        protected void runItem(ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            for (ExecutableScript.ExecutionItem chainItem : this.getSteps()) {
                assistant.executeIfStillRunning(chainItem, true).addListener((Runnable)new AbstractScriptBuilder.ExecutionItemCompletionRunner(chainItem));
            }
            try {
                if (StepResultCollectionUtils.getFailedResult(this.getFutures()) != null) {
                    FutureUtils.cancelIncompleteFutures(this.getFutures(), (boolean)true);
                    return;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }

        @Override
        public void prepareForRun() {
            ExecutableScript.ExecutionItem[] steps = this.getSteps();
            List<ExecutableScript.ExecutionItem> shuffledList = Arrays.asList(steps);
            Collections.shuffle(shuffledList, new Random(Clock.accurateTimeNanos()));
            this.setSteps(shuffledList.toArray(steps));
            super.prepareForRun();
        }

        @Override
        public ParallelStep makeCopy() {
            ParallelStep result = new ParallelStep();
            for (ExecutableScript.ExecutionItem step : this.getSteps()) {
                ExecutableScript.ExecutionItem ei = step.makeCopy();
                if (ei == null) continue;
                result.addItem(ei);
            }
            return result;
        }

        @Override
        public ExecutableScript.ExecutionItem.ChildItems getChildItems() {
            return new AbstractScriptBuilder.ChildItemContainer(this.getSteps(), false);
        }
    }
}

