/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.threadly.load.StepResult;

public class StepResultCollectionUtils {
    public static StepResult getFailedResult(Collection<? extends Future<? extends StepResult>> futures) throws InterruptedException {
        Iterator<? extends Future<? extends StepResult>> it = futures.iterator();
        while (it.hasNext()) {
            try {
                StepResult tr = it.next().get();
                if (tr.getError() == null) continue;
                return tr;
            }
            catch (CancellationException tr) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static List<StepResult> getAllFailedResults(Collection<? extends Future<? extends StepResult>> futures) throws InterruptedException {
        ArrayList<StepResult> result = new ArrayList<StepResult>(2);
        Iterator<? extends Future<? extends StepResult>> it = futures.iterator();
        while (it.hasNext()) {
            try {
                StepResult tr = it.next().get();
                if (tr.getError() == null) continue;
                result.add(tr);
            }
            catch (CancellationException tr) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static double getRunTimeAverage(Collection<? extends Future<? extends StepResult>> futures, TimeUnit timeUnit) throws InterruptedException {
        double count = 0.0;
        double totalNanos = 0.0;
        Iterator<? extends Future<? extends StepResult>> it = futures.iterator();
        while (it.hasNext()) {
            try {
                StepResult tr = it.next().get();
                if (tr.wasMaintanceStep()) continue;
                count += 1.0;
                totalNanos += (double)tr.getRunTime(timeUnit);
            }
            catch (CancellationException tr) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return totalNanos / count;
    }

    public static Map<Double, StepResult> getRunTimePercentiles(Collection<? extends Future<? extends StepResult>> futures, double ... percentiles) throws InterruptedException {
        if (percentiles.length == 0) {
            throw new IllegalArgumentException("No percentiles requested");
        }
        ArrayList<StepResult> runTimes = new ArrayList<StepResult>(futures.size());
        Iterator<? extends Future<? extends StepResult>> it = futures.iterator();
        while (it.hasNext()) {
            try {
                StepResult sr = it.next().get();
                if (sr.wasMaintanceStep()) continue;
                runTimes.add(sr);
            }
            catch (CancellationException sr) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        Collections.sort(runTimes, new Comparator<StepResult>(){

            @Override
            public int compare(StepResult sr1, StepResult sr2) {
                return (int)(sr1.getRunTime(TimeUnit.MILLISECONDS) - sr2.getRunTime(TimeUnit.MILLISECONDS));
            }
        });
        LinkedHashMap<Double, StepResult> result = new LinkedHashMap<Double, StepResult>();
        for (double p : percentiles) {
            if (p > 100.0 || p < 0.0) {
                throw new IllegalArgumentException("Percentile not in range of 0 to 100: " + p);
            }
            int index = p == 100.0 ? runTimes.size() - 1 : (int)(p / 100.0 * (double)runTimes.size());
            result.put(p, (StepResult)runTimes.get(index));
        }
        return result;
    }
}

