/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.threadly.load.ExecutableScript;
import org.threadly.load.ParameterStore;
import org.threadly.load.ScriptFactory;
import org.threadly.util.StringUtils;

abstract class AbstractScriptFactoryInitializer
extends ParameterStore {
    protected final ExecutableScript script;

    protected AbstractScriptFactoryInitializer(String[] args) {
        this(args.length > 0 ? args[0] : null, args.length > 1 ? ParameterStore.parseProperties(args, 1, args.length - 1) : new Properties());
    }

    protected AbstractScriptFactoryInitializer(String classStr, Properties properties) {
        super(properties);
        if (StringUtils.isNullOrEmpty((String)classStr)) {
            System.err.println("ScriptFactory class not provided");
            this.handleInitializationFailure(null);
            this.script = null;
            return;
        }
        ScriptFactory factory = null;
        try {
            Class<?> factoryClass = Class.forName(classStr);
            try {
                factory = (ScriptFactory)factoryClass.newInstance();
            }
            catch (ClassCastException e) {
                System.err.println("Class does not seem to be an instance of " + ScriptFactory.class.getSimpleName() + ": " + classStr);
                this.handleInitializationFailure(null);
            }
            catch (InstantiationException e) {
                System.err.println("Failed to call empty cosntructor on: " + classStr);
                e.printStackTrace();
                this.handleInitializationFailure(null);
            }
            catch (IllegalAccessException e) {
                System.err.println("Failed to call empty cosntructor on: " + classStr);
                e.printStackTrace();
                this.handleInitializationFailure(null);
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find class in classpath: " + classStr);
            this.handleInitializationFailure(null);
        }
        if (factory == null) {
            this.script = null;
            return;
        }
        factory.initialize(properties);
        try {
            this.script = factory.buildScript();
        }
        catch (ParameterStore.ParameterException e) {
            Map<String, String> runnerParams;
            HashMap<String, String> paramDocs = new HashMap<String, String>();
            Map<String, String> factoryParams = factory.getPossibleParameters();
            if (factoryParams != null) {
                paramDocs.putAll(factoryParams);
            }
            if ((runnerParams = this.getPossibleParameters()) != null) {
                paramDocs.putAll(runnerParams);
            }
            if (paramDocs.isEmpty()) {
                throw e;
            }
            System.err.println("Failure with script parameters..." + e.getMessage());
            if (e.getCause() != null) {
                System.err.println("Cause exception: ");
                e.getCause().printStackTrace();
            }
            System.err.println("Possible parameters:");
            System.err.println();
            Iterator it = paramDocs.entrySet().iterator();
            StringBuilder paramDefs = new StringBuilder();
            while (it.hasNext()) {
                Map.Entry param = it.next();
                paramDefs.append((String)param.getKey());
                if (param.getValue() != null && !((String)param.getValue()).isEmpty()) {
                    for (int i = ((String)param.getKey()).length(); i < 10; ++i) {
                        paramDefs.append(" ");
                    }
                    paramDefs.append(" - ").append((String)param.getValue());
                }
                paramDefs.append(System.lineSeparator()).append(System.lineSeparator());
            }
            System.err.print(paramDefs.toString());
            this.handleInitializationFailure(factory.getClass().getName());
            throw e;
        }
    }

    protected abstract void handleInitializationFailure(String var1);
}

