/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.threadly.load.CharsDeduplicator;
import org.threadly.load.ScriptStep;
import org.threadly.load.ScriptStepType;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.StringUtils;

public abstract class AbstractScriptStep
implements ScriptStep {
    private static final Map<String, String> PARAMS = new ConcurrentHashMap<String, String>();
    protected final CharSequence identifier;
    protected final ScriptStepType stepType;

    public static void setGlobalParam(String key, String value) {
        PARAMS.put(key, value);
    }

    public static String removeGlobalParam(String key) {
        return PARAMS.remove(key);
    }

    public static String getGlobalParam(String key) {
        return StringUtils.nullToEmpty((String)PARAMS.get(key));
    }

    protected AbstractScriptStep(CharSequence identifier) {
        this(identifier, ScriptStepType.Normal);
    }

    protected AbstractScriptStep(CharSequence identifier, ScriptStepType stepType) {
        ArgumentVerifier.assertNotNull((Object)((Object)stepType), (String)"stepType");
        this.identifier = identifier instanceof String ? CharsDeduplicator.deDuplicate((String)identifier) : (identifier == null ? "" : identifier);
        this.stepType = stepType;
    }

    @Override
    public ScriptStepType getStepType() {
        return this.stepType;
    }

    @Override
    public CharSequence getIdentifier() {
        return this.identifier;
    }
}

