/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import org.threadly.load.LightCharSequence;

public class CharSequenceChain
implements CharSequence {
    private static final int HASH_START_PRIME = 31;
    private final CharSequence[] chain;

    public CharSequenceChain(CharSequence ... chain) {
        int index = 0;
        CharSequence[] fooChain = new CharSequence[chain.length];
        for (CharSequence cs : chain) {
            if (cs.length() <= 0) continue;
            if (cs instanceof String) {
                cs = new LightCharSequence(((String)cs).toCharArray());
            }
            fooChain[index++] = cs;
        }
        if (index == chain.length) {
            this.chain = fooChain;
        } else {
            CharSequence[] newChain = new CharSequence[index];
            System.arraycopy(fooChain, 0, newChain, 0, index);
            this.chain = newChain;
        }
    }

    @Override
    public char charAt(int index) {
        int currIndex = 0;
        for (CharSequence cs : this.chain) {
            if (currIndex + cs.length() > index) {
                return cs.charAt(index - currIndex);
            }
            currIndex += cs.length();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int length() {
        int result = 0;
        for (CharSequence cs : this.chain) {
            result += cs.length();
        }
        return result;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        char[] resultArray = new char[end - start];
        for (int i = 0; i < resultArray.length; ++i) {
            resultArray[i] = this.charAt(start + i);
        }
        return new LightCharSequence(resultArray);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence cs : this.chain) {
            sb.append(cs);
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 31;
        for (CharSequence cs : this.chain) {
            result ^= cs.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharSequence) {
            return this.toString().equals(o.toString());
        }
        return false;
    }
}

