/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.threadly.concurrent.PriorityScheduler;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.future.ExecuteOnGetFutureTask;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ImmediateResultListenableFuture;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.SettableListenableFuture;
import org.threadly.concurrent.wrapper.limiter.RateLimiterExecutor;
import org.threadly.load.CharsDeduplicator;
import org.threadly.load.StepResult;
import org.threadly.load.StepResultCollectionUtils;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;

public class ExecutableScript {
    private static final int MAXIMUM_PRESTART_THREAD_COUNT = 1000;
    protected final int neededThreadQty;
    protected final ExecutionItem startExecutionItem;
    protected final ScriptAssistant scriptAssistant;

    public ExecutableScript(int neededThreadQty, ExecutionItem startExecutionItem) {
        if (!startExecutionItem.getChildItems().hasChildren()) {
            throw new IllegalArgumentException("Can not construct script with no steps");
        }
        ArgumentVerifier.assertGreaterThanZero((double)neededThreadQty, (String)"neededThreadQty");
        this.neededThreadQty = neededThreadQty;
        this.startExecutionItem = startExecutionItem;
        this.scriptAssistant = new ScriptAssistant();
    }

    public int getThreadQtyNeeded() {
        return this.neededThreadQty;
    }

    public List<ListenableFuture<StepResult>> startScript() {
        final ArrayList<ListenableFuture<StepResult>> result = new ArrayList<ListenableFuture<StepResult>>(0);
        this.startExecutionItem.prepareForRun();
        result.addAll(this.startExecutionItem.getFutures());
        result.trimToSize();
        CharsDeduplicator.clearCache();
        this.scriptAssistant.start(this.neededThreadQty + 1, result);
        System.gc();
        ((PriorityScheduler)this.scriptAssistant.scheduler.get()).execute(new Runnable(){

            @Override
            public void run() {
                ExecutableScript.this.startExecutionItem.itemReadyForExecution(ExecutableScript.this.scriptAssistant);
                try {
                    if (StepResultCollectionUtils.getFailedResult(result) != null) {
                        FutureUtils.cancelIncompleteFutures(ExecutableScript.this.scriptAssistant.getGlobalRunningFutureSet(), (boolean)true);
                        return;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                finally {
                    ExecutableScript.this.startExecutionItem.runComplete();
                }
            }
        });
        return result;
    }

    protected static interface ExecutionItem {
        public void setStartHandler(StepStartHandler var1);

        public void prepareForRun();

        public void runComplete();

        public void itemReadyForExecution(ExecutionAssistant var1);

        public boolean manipulatesExecutionAssistant();

        public boolean isChainExecutor();

        public List<? extends SettableListenableFuture<StepResult>> getFutures();

        public ExecutionItem makeCopy();

        public ChildItems getChildItems();

        public static interface StepStartHandler {
            public void readyToRun(ExecutionItem var1, ExecutionAssistant var2);
        }

        public static interface ExecutionAssistant {
            public ListenableFuture<?> executeIfStillRunning(ExecutionItem var1, boolean var2);

            public void executeAsyncMaintenanceTaskIfStillRunning(Runnable var1);

            public void setStepPerSecondLimit(double var1);

            public List<ListenableFuture<StepResult>> getGlobalRunningFutureSet();

            public ExecutionAssistant makeCopy();

            public void registerFailureNotification(Runnable var1);

            public void markGlobalFailure();

            public boolean getMarkedGlobalFailure();
        }

        public static interface ChildItems
        extends Iterable<ExecutionItem> {
            public boolean itemsRunSequential();

            public boolean hasChildren();

            @Override
            public Iterator<ExecutionItem> iterator();
        }
    }

    private static class ScriptAssistant
    implements ExecutionItem.ExecutionAssistant {
        private final AtomicBoolean running;
        private final AtomicReference<PriorityScheduler> scheduler;
        private final AtomicReference<List<ListenableFuture<StepResult>>> futures;
        private final AtomicBoolean markedFailure;
        private final ArrayList<Runnable> failureListeners;
        private volatile ListenableFuture<?> completionFuture;
        private volatile SubmitterExecutor limiter;

        private ScriptAssistant(ScriptAssistant scriptAssistant) {
            this.running = scriptAssistant.running;
            this.scheduler = scriptAssistant.scheduler;
            this.futures = scriptAssistant.futures;
            this.markedFailure = scriptAssistant.markedFailure;
            this.failureListeners = scriptAssistant.failureListeners;
            this.limiter = scriptAssistant.limiter;
            this.completionFuture = scriptAssistant.completionFuture;
            this.completionFuture.listener(new Runnable(){

                @Override
                public void run() {
                    limiter = null;
                }
            });
        }

        public ScriptAssistant() {
            this.running = new AtomicBoolean(false);
            this.scheduler = new AtomicReference<Object>(null);
            this.futures = new AtomicReference<Object>(null);
            this.markedFailure = new AtomicBoolean(false);
            this.failureListeners = new ArrayList(1);
            this.limiter = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerFailureNotification(Runnable listener) {
            ArrayList<Runnable> arrayList = this.failureListeners;
            synchronized (arrayList) {
                if (this.markedFailure.get()) {
                    try {
                        listener.run();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleException((Throwable)t);
                    }
                } else {
                    this.failureListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void markGlobalFailure() {
            if (!this.markedFailure.get() && this.markedFailure.compareAndSet(false, true)) {
                ArrayList<Runnable> arrayList = this.failureListeners;
                synchronized (arrayList) {
                    for (Runnable r : this.failureListeners) {
                        try {
                            r.run();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleException((Throwable)t);
                        }
                    }
                    this.failureListeners.clear();
                }
                List<ListenableFuture<StepResult>> futures = this.futures.get();
                if (futures != null) {
                    FutureUtils.cancelIncompleteFutures(futures, (boolean)true);
                }
            }
        }

        @Override
        public boolean getMarkedGlobalFailure() {
            return this.markedFailure.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(int threadPoolSize, List<ListenableFuture<StepResult>> futures) {
            PriorityScheduler ps;
            if (!this.running.compareAndSet(false, true)) {
                throw new IllegalStateException("Already running");
            }
            if (threadPoolSize > 1000) {
                ps = new PriorityScheduler(1000);
                ps.prestartAllThreads();
                ps.setPoolSize(threadPoolSize);
            } else {
                ps = new PriorityScheduler(threadPoolSize);
                ps.prestartAllThreads();
            }
            this.scheduler.set(ps);
            this.futures.set(Collections.unmodifiableList(futures));
            this.completionFuture = FutureUtils.makeCompleteFuture(futures);
            this.completionFuture.listener(new Runnable(){

                @Override
                public void run() {
                    scheduler.set(null);
                    limiter = null;
                    running.set(false);
                }
            });
            ArrayList<Runnable> arrayList = this.failureListeners;
            synchronized (arrayList) {
                this.failureListeners.trimToSize();
            }
        }

        @Override
        public List<ListenableFuture<StepResult>> getGlobalRunningFutureSet() {
            return this.futures.get();
        }

        @Override
        public void executeAsyncMaintenanceTaskIfStillRunning(Runnable task) {
            PriorityScheduler ps = this.scheduler.get();
            if (ps != null) {
                ps.execute(task, TaskPriority.Starvable);
            }
        }

        @Override
        public ListenableFuture<?> executeIfStillRunning(ExecutionItem item, boolean forceAsync) {
            SubmitterExecutor limiter = this.limiter;
            if (limiter != null && !item.isChainExecutor()) {
                return limiter.submit(this.wrapInRunnable(item));
            }
            PriorityScheduler scheduler = this.scheduler.get();
            if (scheduler != null) {
                if (forceAsync) {
                    ExecuteOnGetFutureTask result = new ExecuteOnGetFutureTask(this.wrapInRunnable(item));
                    scheduler.execute((Runnable)result);
                    return result;
                }
                item.itemReadyForExecution(this);
            }
            return ImmediateResultListenableFuture.NULL_RESULT;
        }

        private Runnable wrapInRunnable(final ExecutionItem item) {
            return new Runnable(){

                @Override
                public void run() {
                    item.itemReadyForExecution(this);
                }
            };
        }

        @Override
        public void setStepPerSecondLimit(double newLimit) {
            if (newLimit <= 0.0) {
                this.limiter = null;
            } else {
                PriorityScheduler scheduler = this.scheduler.get();
                if (scheduler != null) {
                    this.limiter = new RateLimiterExecutor((SubmitterScheduler)scheduler, newLimit);
                }
            }
        }

        @Override
        public ScriptAssistant makeCopy() {
            return new ScriptAssistant(this);
        }
    }
}

