/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

public class LightCharSequence
implements CharSequence {
    private static final int HASH_START_PRIME = 31;
    protected final char[] chars;

    public LightCharSequence(char[] chars) {
        this.chars = chars;
    }

    @Override
    public char charAt(int i) {
        return this.chars[i];
    }

    @Override
    public int length() {
        return this.chars.length;
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        int size = arg1 - arg0;
        if (size < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (size == 0) {
            return new LightCharSequence(new char[0]);
        }
        char[] resultChars = new char[size];
        System.arraycopy(this.chars, arg0, resultChars, 0, size);
        return new LightCharSequence(resultChars);
    }

    @Override
    public String toString() {
        return new String(this.chars).intern();
    }

    public boolean equals(Object o) {
        CharSequence cs;
        if (this == o) {
            return true;
        }
        if (o instanceof CharSequence && this.chars.length == (cs = (CharSequence)o).length()) {
            for (int i = 0; i < this.chars.length; ++i) {
                if (this.chars[i] == cs.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 31;
        for (char c : this.chars) {
            result ^= c;
        }
        return result;
    }
}

