/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.threadly.util.ArgumentVerifier;

public class ParameterStore {
    protected Properties properties = null;

    public static Properties parseProperties(String[] args, int offset, int length) {
        if (offset < 0 || offset > args.length) {
            throw new IndexOutOfBoundsException("Offset out of range: " + offset + ", " + length + " - " + args.length);
        }
        if (length < 0 || offset + length > args.length) {
            throw new IndexOutOfBoundsException("Length out of range: " + offset + ", " + length + " - " + args.length);
        }
        Properties properties = new Properties();
        for (int i = 0; i < length; ++i) {
            int delimIndex = args[offset + i].indexOf(61);
            if (delimIndex < 1) {
                System.err.println("Ignoring unknown key/value argument: " + args[offset + i]);
                continue;
            }
            properties.put(args[offset + i].substring(0, delimIndex), args[offset + i].substring(delimIndex + 1));
        }
        return properties;
    }

    public ParameterStore() {
        this(null);
    }

    public ParameterStore(Properties properties) {
        this.properties = properties;
    }

    protected void initialize(Properties properties) {
        ArgumentVerifier.assertNotNull((Object)properties, (String)"properties");
        if (this.properties != null) {
            throw new IllegalStateException("Alread initialized");
        }
        this.properties = properties;
    }

    public Map<String, String> getPossibleParameters() {
        return Collections.emptyMap();
    }

    public boolean getBoolValue(String key) {
        String str = this.getStringValue(key);
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParameterException("Can not parse boolean from: " + str);
    }

    public int getIntValue(String key) {
        try {
            return Integer.parseInt(this.getStringValue(key));
        }
        catch (NumberFormatException e) {
            throw new ParameterException(e);
        }
    }

    public long getLongValue(String key) {
        try {
            return Long.parseLong(this.getStringValue(key));
        }
        catch (NumberFormatException e) {
            throw new ParameterException(e);
        }
    }

    public double getDoubleValue(String key) {
        try {
            return Double.parseDouble(this.getStringValue(key));
        }
        catch (NumberFormatException e) {
            throw new ParameterException(e);
        }
    }

    public String getStringValue(String key) {
        String result = this.properties.getProperty(key);
        if (result == null) {
            throw new ParameterException("No property for key: " + key);
        }
        return result;
    }

    public boolean getBoolValue(String key, boolean defaultVal) {
        String result = this.properties.getProperty(key);
        if (result == null) {
            return defaultVal;
        }
        if (result.equalsIgnoreCase("true")) {
            return true;
        }
        if (result.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParameterException("Can not parse boolean from: " + result);
    }

    public int getIntValue(String key, int defaultVal) {
        String result = this.properties.getProperty(key);
        if (result == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            throw new ParameterException(e);
        }
    }

    public long getLongValue(String key, long defaultVal) {
        String result = this.properties.getProperty(key);
        if (result == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(result);
        }
        catch (NumberFormatException e) {
            throw new ParameterException(e);
        }
    }

    public double getDoubleValue(String key, double defaultVal) {
        String result = this.properties.getProperty(key);
        if (result == null) {
            return defaultVal;
        }
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            throw new ParameterException(e);
        }
    }

    public String getStringValue(String key, String defaultVal) {
        String result = this.properties.getProperty(key);
        if (result == null) {
            return defaultVal;
        }
        return result;
    }

    public static class ParameterException
    extends RuntimeException {
        private static final long serialVersionUID = -1913265153770464976L;

        public ParameterException(String msg) {
            super(msg);
        }

        public ParameterException(Throwable cause) {
            super(cause);
        }

        public ParameterException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

