/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.threadly.load.AbstractScriptBuilder;
import org.threadly.load.ExecutableScript;
import org.threadly.load.ParallelScriptBuilder;
import org.threadly.util.Pair;

public class ScriptBuilderUtils {
    public static ParallelScriptBuilder balanceBuilders(AbstractScriptBuilder ... builders) {
        if (builders.length == 0) {
            return new ParallelScriptBuilder();
        }
        if (builders.length == 1) {
            if (builders[0] instanceof ParallelScriptBuilder) {
                return (ParallelScriptBuilder)builders[0];
            }
            ParallelScriptBuilder result = new ParallelScriptBuilder();
            result.addSteps(builders[0]);
            return result;
        }
        int largestBuilderCount = -1;
        AbstractScriptBuilder largestBuilder = null;
        ArrayList<Pair> flowControlledBuilders = new ArrayList<Pair>(builders.length - 1);
        for (AbstractScriptBuilder builder : builders) {
            int builderCount = ScriptBuilderUtils.countScriptSteps(builder.getStepAsExecutionItem().getChildItems());
            if (builderCount == 0) continue;
            if (builderCount > largestBuilderCount) {
                if (largestBuilder != null) {
                    flowControlledBuilders.add(new Pair((Object)largestBuilder, (Object)largestBuilderCount));
                }
                largestBuilderCount = builderCount;
                largestBuilder = builder;
                continue;
            }
            flowControlledBuilders.add(new Pair((Object)builder, (Object)builderCount));
        }
        if (!flowControlledBuilders.isEmpty()) {
            RunSignalAcceptor[] signalAcceptors = new RunSignalAcceptor[flowControlledBuilders.size()];
            for (int i = 0; i < flowControlledBuilders.size(); ++i) {
                Pair fcBuilder = (Pair)flowControlledBuilders.get(i);
                signalAcceptors[i] = new RunSignalAcceptor(largestBuilderCount / (Integer)fcBuilder.getRight());
                ((AbstractScriptBuilder)fcBuilder.getLeft()).setStartHandlerOnAllSteps(signalAcceptors[i]);
            }
            largestBuilder.setStartHandlerOnAllSteps(new RunSignalSender(signalAcceptors));
        }
        ParallelScriptBuilder result = new ParallelScriptBuilder();
        for (AbstractScriptBuilder builder : builders) {
            result.addSteps(builder);
        }
        return result;
    }

    private static int countScriptSteps(ExecutableScript.ExecutionItem.ChildItems items) {
        int count = 0;
        for (ExecutableScript.ExecutionItem item : items) {
            if (item.isChainExecutor()) {
                count += ScriptBuilderUtils.countScriptSteps(item.getChildItems());
                continue;
            }
            ++count;
        }
        return count;
    }

    private static class RunSignalSender
    implements ExecutableScript.ExecutionItem.StepStartHandler {
        private final RunSignalAcceptor[] signalAcceptors;

        public RunSignalSender(RunSignalAcceptor[] signalAcceptors) {
            this.signalAcceptors = signalAcceptors;
        }

        @Override
        public void readyToRun(ExecutableScript.ExecutionItem step, ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            for (RunSignalAcceptor rsa : this.signalAcceptors) {
                rsa.handleRunSignal();
            }
            step.setStartHandler(null);
            step.itemReadyForExecution(assistant);
        }
    }

    private static class RunSignalAcceptor
    implements ExecutableScript.ExecutionItem.StepStartHandler {
        private final int neededSignalCountPerStep;
        private final AtomicBoolean registeredForFailures;
        private final Semaphore runSemaphore;

        public RunSignalAcceptor(int neededSignalCountPerStep) {
            this.neededSignalCountPerStep = neededSignalCountPerStep;
            this.registeredForFailures = new AtomicBoolean(false);
            this.runSemaphore = new Semaphore(neededSignalCountPerStep / 2, true);
        }

        public void handleRunSignal() {
            this.runSemaphore.release();
        }

        @Override
        public void readyToRun(ExecutableScript.ExecutionItem step, ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            if (!this.registeredForFailures.get() && this.registeredForFailures.compareAndSet(false, true)) {
                assistant.registerFailureNotification(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                runSemaphore.release(16383);
                            }
                        }
                        catch (Throwable throwable) {
                            return;
                        }
                    }
                });
            }
            try {
                this.runSemaphore.acquire(this.neededSignalCountPerStep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            step.setStartHandler(null);
            step.itemReadyForExecution(assistant);
        }
    }
}

