/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.load.AbstractScriptFactoryInitializer;
import org.threadly.load.StepResult;
import org.threadly.load.StepResultCollectionUtils;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionHandler;
import org.threadly.util.ExceptionUtils;
import org.threadly.util.StringUtils;

public class ScriptRunner
extends AbstractScriptFactoryInitializer {
    private static final double[] RETURNED_PERCENTILES = new double[]{50.0, 75.0, 80.0, 85.0, 90.0, 95.0, 98.0, 99.0, 99.5, 99.9, 100.0};
    private static final boolean TRIM_AMBUSH_STACK_AWAY = true;

    public static void main(String[] args) throws Exception {
        ScriptRunner.setupExceptionHandler();
        ScriptRunner runner = null;
        try {
            runner = new ScriptRunner(args);
        }
        catch (Throwable t) {
            System.err.println("Unexpected failure when building script: ");
            ScriptRunner.printFailureAndExit(t);
        }
        System.exit(runner.runScript());
    }

    protected static void setupExceptionHandler() {
        ExceptionUtils.setDefaultExceptionHandler((ExceptionHandler)new ExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleException(Throwable thrown) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    System.err.println("Unexpected uncaught exception: ");
                    ScriptRunner.printFailureAndExit(thrown);
                }
            }
        });
    }

    protected static void printFailureAndExit(Throwable t) {
        t.printStackTrace();
        int hashCode = StringUtils.nullToEmpty((String)t.getMessage()).hashCode();
        if (hashCode == 0) {
            hashCode = -1;
        }
        if (hashCode > 0) {
            hashCode *= -1;
        }
        System.exit(hashCode);
    }

    protected ScriptRunner(String[] args) {
        super(args);
    }

    @Override
    protected void handleInitializationFailure(String buildingScript) {
        if (buildingScript == null || buildingScript.isEmpty()) {
            buildingScript = "script.factory.to.call";
        }
        System.err.println("java " + this.getClass().getName() + " " + buildingScript + " key1=value1 key2=value2....");
        System.exit(-1);
    }

    protected void out(String msg) {
        System.out.println(msg);
    }

    protected void handleRunFinish(List<ListenableFuture<StepResult>> rawFutures, List<StepResult> fails, long runDurationMillis) throws Exception {
        if (fails.isEmpty()) {
            this.out("All steps passed!");
        } else {
            HashMap<String, ArrayList<StepResult>> failureCountMap = new HashMap<String, ArrayList<StepResult>>();
            this.out(fails.size() + " STEPS FAILED!!" + System.lineSeparator());
            Iterator<Object> it = fails.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (it.hasNext()) {
                stringBuilder.setLength(0);
                StepResult tr = (StepResult)it.next();
                for (Iterator t = tr.getError(); t != null; t = ((Throwable)((Object)t)).getCause()) {
                    int i;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("Caused by: ");
                    }
                    stringBuilder.append(((Throwable)((Object)t)).toString()).append(System.lineSeparator());
                    StackTraceElement[] origStack = ((Throwable)((Object)t)).getStackTrace();
                    String packageStr = ScriptRunner.class.getPackage().getName();
                    for (i = 1; i < origStack.length && !origStack[i].getClassName().startsWith(packageStr); ++i) {
                    }
                    StackTraceElement[] trimmedStack = Arrays.copyOf(origStack, i);
                    ExceptionUtils.writeStackTo((StackTraceElement[])trimmedStack, (StringBuilder)stringBuilder);
                }
                String errorMsg = stringBuilder.toString();
                ArrayList<StepResult> currentSteps = (ArrayList<StepResult>)failureCountMap.get(errorMsg);
                if (currentSteps == null) {
                    currentSteps = new ArrayList<StepResult>(1);
                    failureCountMap.put(errorMsg, currentSteps);
                }
                currentSteps.add(tr);
            }
            for (Map.Entry entry : failureCountMap.entrySet()) {
                if (((List)entry.getValue()).size() > 1) {
                    ArrayList<String> descriptions = new ArrayList<String>(((List)entry.getValue()).size());
                    for (StepResult sr : (List)entry.getValue()) {
                        if (descriptions.contains(sr.getDescription())) continue;
                        descriptions.add(sr.getDescription());
                    }
                    this.out("Error occured " + ((List)entry.getValue()).size() + " times for the following steps:");
                    for (String s : descriptions) {
                        this.out('\t' + s);
                    }
                    this.out("All share failure cause:");
                } else {
                    this.out("Step " + ((StepResult)((List)entry.getValue()).get(0)).getDescription() + " failed due to:");
                }
                this.out((String)entry.getKey() + System.lineSeparator());
            }
        }
        int totalExecuted = 0;
        for (ListenableFuture<StepResult> listenableFuture : rawFutures) {
            if (listenableFuture.isCancelled()) continue;
            ++totalExecuted;
        }
        this.out("Totals steps executed: " + totalExecuted + " / " + rawFutures.size());
        this.out("Test execution time: " + runDurationMillis / 1000L + " seconds");
        double averageRunMillis = StepResultCollectionUtils.getRunTimeAverage(rawFutures, TimeUnit.MILLISECONDS);
        this.out("Average time spent per step: " + averageRunMillis + " milliseconds");
        Map<Double, StepResult> percentileResults = StepResultCollectionUtils.getRunTimePercentiles(rawFutures, RETURNED_PERCENTILES);
        for (Map.Entry<Double, StepResult> e : percentileResults.entrySet()) {
            if (!(e.getKey() < 100.0)) continue;
            this.out("Percentile " + e.getKey() + ": " + e.getValue().getRunTime(TimeUnit.MILLISECONDS) + " milliseconds");
        }
        StepResult longestStep = percentileResults.get(RETURNED_PERCENTILES[RETURNED_PERCENTILES.length - 1]);
        this.out("Longest running step: " + longestStep.getDescription() + ", ran for: " + longestStep.getRunTime(TimeUnit.MILLISECONDS) + " milliseconds");
    }

    protected int runScript() throws Exception {
        long start = Clock.accurateForwardProgressingMillis();
        List<ListenableFuture<StepResult>> futures = this.script.startScript();
        List<StepResult> fails = StepResultCollectionUtils.getAllFailedResults(futures);
        long end = Clock.accurateForwardProgressingMillis();
        this.handleRunFinish(futures, fails, end - start);
        return fails.size();
    }
}

