/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.load;

import java.util.concurrent.ExecutionException;
import org.threadly.concurrent.future.FutureUtils;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.load.AbstractScriptBuilder;
import org.threadly.load.ExecutableScript;
import org.threadly.load.ParallelScriptBuilder;
import org.threadly.load.ScriptStep;
import org.threadly.load.StepResultCollectionUtils;
import org.threadly.util.ExceptionUtils;

public class SequentialScriptBuilder
extends AbstractScriptBuilder {
    protected final SequentialStep currentStep = new SequentialStep();

    @Override
    public boolean hasSteps() {
        return this.currentStep.getStepCount() > 0;
    }

    @Override
    protected ExecutableScript.ExecutionItem getStepAsExecutionItem() {
        return this.currentStep;
    }

    @Override
    protected void setStartHandlerOnAllSteps(ExecutableScript.ExecutionItem.StepStartHandler startHandler) {
        SequentialScriptBuilder.setStartHandler(this.currentStep.getChildItems(), startHandler);
    }

    @Override
    public SequentialScriptBuilder makeCopy() {
        SequentialScriptBuilder result = new SequentialScriptBuilder();
        for (ExecutableScript.ExecutionItem item : this.currentStep.getSteps()) {
            result.addStep(item.makeCopy());
        }
        return result;
    }

    @Override
    public int getMaximumNeededThreadCount() {
        return super.getMaximumNeededThreadCount() + 1;
    }

    @Override
    public void addStep(ScriptStep step) {
        this.addStep(new AbstractScriptBuilder.ScriptStepRunner(step));
    }

    @Override
    protected void addStep(ExecutableScript.ExecutionItem step) {
        this.verifyValid();
        this.currentStep.addItem(step);
    }

    @Override
    public void addSteps(SequentialScriptBuilder sequentialSteps) {
        this.verifyValid();
        sequentialSteps.replaced();
        if (!sequentialSteps.hasSteps()) {
            return;
        }
        this.maybeUpdatedMaximumThreads(sequentialSteps.getMaximumNeededThreadCount());
        this.currentStep.addItems(sequentialSteps.currentStep.getSteps());
    }

    @Override
    public void addSteps(ParallelScriptBuilder parallelSteps) {
        this.verifyValid();
        parallelSteps.replaced();
        if (!parallelSteps.hasSteps()) {
            return;
        }
        this.maybeUpdatedMaximumThreads(parallelSteps.getMaximumNeededThreadCount());
        this.addStep(parallelSteps.currentStep);
    }

    protected static class SequentialStep
    extends AbstractScriptBuilder.StepCollectionRunner {
        protected SequentialStep() {
        }

        @Override
        protected void runItem(ExecutableScript.ExecutionItem.ExecutionAssistant assistant) {
            for (ExecutableScript.ExecutionItem chainItem : this.getSteps()) {
                if (chainItem.manipulatesExecutionAssistant()) {
                    assistant = assistant.makeCopy();
                }
                ListenableFuture<?> f = assistant.executeIfStillRunning(chainItem, false);
                f.listener((Runnable)new AbstractScriptBuilder.ExecutionItemCompletionRunner(chainItem));
                try {
                    f.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException e) {
                    throw ExceptionUtils.makeRuntime((Throwable)e.getCause());
                }
                try {
                    if (StepResultCollectionUtils.getFailedResult(chainItem.getFutures()) == null) continue;
                    FutureUtils.cancelIncompleteFutures(this.getFutures(), (boolean)true);
                    return;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        @Override
        public SequentialStep makeCopy() {
            SequentialStep result = new SequentialStep();
            for (ExecutableScript.ExecutionItem chainItem : this.getSteps()) {
                ExecutableScript.ExecutionItem copy = chainItem.makeCopy();
                if (copy == null) continue;
                result.addItem(copy);
            }
            return result;
        }

        @Override
        public ExecutableScript.ExecutionItem.ChildItems getChildItems() {
            return new AbstractScriptBuilder.ChildItemContainer(this.getSteps(), true);
        }
    }
}

