/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.db.aurora.psql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.Driver;
import org.threadly.db.aurora.AuroraServer;
import org.threadly.db.aurora.DelegateAuroraDriver;

public class PsqlDelegateDriver
extends DelegateAuroraDriver {
    public PsqlDelegateDriver() {
        this((java.sql.Driver)new Driver());
    }

    public PsqlDelegateDriver(java.sql.Driver driver) {
        super("jdbc:postgresql:aurora://", "jdbc:postgresql://", driver);
    }

    public String getDriverName() {
        return "auroraArc-psql";
    }

    public boolean isMasterServer(AuroraServer server, Connection connection) throws SQLException {
        int serverIdDelim = server.getHost().indexOf(46);
        if (serverIdDelim < 0) {
            throw new IllegalStateException("Invalid host: " + server.getHost());
        }
        String serverId = server.getHost().substring(0, serverIdDelim);
        try (PreparedStatement ps = connection.prepareStatement("SELECT server_id, session_id FROM aurora_replica_status();");
             ResultSet results = ps.executeQuery();){
            int count = 0;
            while (results.next()) {
                ++count;
                if (!serverId.equalsIgnoreCase(results.getString("server_id"))) continue;
                boolean bl = "MASTER_SESSION_ID".equalsIgnoreCase(results.getString("session_id"));
                return bl;
            }
            throw new DelegateAuroraDriver.IllegalDriverStateException("Could not find server '" + serverId + "' in cluster of " + count);
        }
    }
}

