/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.db;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.threadly.db.AbstractArcDriver;
import org.threadly.db.aurora.Driver;

public class LoggingDriver
extends AbstractArcDriver {
    public static final String URL_PREFIX = "jdbc:mysql:logging://";
    protected static final String DELEGATE_DRIVER_PREFIX;
    protected static final java.sql.Driver DELEGATE_DRIVER;
    private final String logPrefix = Integer.toHexString(System.identityHashCode(this)) + "-SqlDriver> ";

    public static void registerDriver() {
    }

    protected void log(String msg) {
        System.out.println(this.logPrefix + msg);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (this.acceptsURL(url)) {
            Connection c = DELEGATE_DRIVER.connect(url.replace(URL_PREFIX, DELEGATE_DRIVER_PREFIX), info);
            if (c != null) {
                c = new LoggingConnection(c);
            } else {
                System.err.println("No connection from delegate driver!");
            }
            return c;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return DELEGATE_DRIVER.getPropertyInfo(url, info);
    }

    @Override
    public boolean jdbcCompliant() {
        return DELEGATE_DRIVER.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return DELEGATE_DRIVER.getParentLogger();
    }

    static {
        try {
            DELEGATE_DRIVER_PREFIX = "jdbc:mysql:aurora://";
            DELEGATE_DRIVER = new Driver();
            DriverManager.registerDriver(new LoggingDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected class LoggingCallableStatement
    extends LoggingPreparedStatement
    implements CallableStatement {
        private final CallableStatement cs;

        public LoggingCallableStatement(CallableStatement prepareCall) {
            super(prepareCall);
            this.cs = prepareCall;
        }

        @Override
        protected String getStatementLogType() {
            return "CallableStatement";
        }

        @Override
        public Array getArray(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getArray:" + parameterIndex);
            return this.cs.getArray(parameterIndex);
        }

        @Override
        public Array getArray(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getArray:" + parameterName);
            return this.cs.getArray(parameterName);
        }

        @Override
        public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBigDecimal:" + parameterIndex);
            return this.cs.getBigDecimal(parameterIndex);
        }

        @Override
        public BigDecimal getBigDecimal(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBigDecimal:" + parameterName);
            return this.cs.getBigDecimal(parameterName);
        }

        @Override
        public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBigDecimal:" + parameterIndex + "," + scale);
            return this.cs.getBigDecimal(parameterIndex, scale);
        }

        @Override
        public Blob getBlob(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBlob:" + parameterIndex);
            return this.cs.getBlob(parameterIndex);
        }

        @Override
        public Blob getBlob(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBlob:" + parameterName);
            return this.cs.getBlob(parameterName);
        }

        @Override
        public boolean getBoolean(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBoolean:" + parameterIndex);
            return this.cs.getBoolean(parameterIndex);
        }

        @Override
        public boolean getBoolean(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBoolean:" + parameterName);
            return this.cs.getBoolean(parameterName);
        }

        @Override
        public byte getByte(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getByte:" + parameterIndex);
            return this.cs.getByte(parameterIndex);
        }

        @Override
        public byte getByte(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getByte:" + parameterName);
            return this.cs.getByte(parameterName);
        }

        @Override
        public byte[] getBytes(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBytes:" + parameterIndex);
            return this.cs.getBytes(parameterIndex);
        }

        @Override
        public byte[] getBytes(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getBytes:" + parameterName);
            return this.cs.getBytes(parameterName);
        }

        @Override
        public Reader getCharacterStream(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getCharacterStream:" + parameterIndex);
            return this.cs.getCharacterStream(parameterIndex);
        }

        @Override
        public Reader getCharacterStream(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getCharacterStream:" + parameterName);
            return this.cs.getCharacterStream(parameterName);
        }

        @Override
        public Clob getClob(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getClob:" + parameterIndex);
            return this.cs.getClob(parameterIndex);
        }

        @Override
        public Clob getClob(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getClob:" + parameterName);
            return this.cs.getClob(parameterName);
        }

        @Override
        public Date getDate(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getDate:" + parameterIndex);
            return this.cs.getDate(parameterIndex);
        }

        @Override
        public Date getDate(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getDate:" + parameterName);
            return this.cs.getDate(parameterName);
        }

        @Override
        public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getDate:" + parameterIndex + "," + cal);
            return this.cs.getDate(parameterIndex, cal);
        }

        @Override
        public Date getDate(String parameterName, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getDate:" + parameterName + "," + cal);
            return this.cs.getDate(parameterName, cal);
        }

        @Override
        public double getDouble(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getDouble:" + parameterIndex);
            return this.cs.getDouble(parameterIndex);
        }

        @Override
        public double getDouble(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getDouble:" + parameterName);
            return this.cs.getDouble(parameterName);
        }

        @Override
        public float getFloat(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getFloat:" + parameterIndex);
            return this.cs.getFloat(parameterIndex);
        }

        @Override
        public float getFloat(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getFloat:" + parameterName);
            return this.cs.getFloat(parameterName);
        }

        @Override
        public int getInt(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getInt:" + parameterIndex);
            return this.cs.getInt(parameterIndex);
        }

        @Override
        public int getInt(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getInt:" + parameterName);
            return this.cs.getInt(parameterName);
        }

        @Override
        public long getLong(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getLong:" + parameterIndex);
            return this.cs.getLong(parameterIndex);
        }

        @Override
        public long getLong(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getLong:" + parameterName);
            return this.cs.getLong(parameterName);
        }

        @Override
        public Reader getNCharacterStream(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getNCharacterStream:" + parameterIndex);
            return this.cs.getNCharacterStream(parameterIndex);
        }

        @Override
        public Reader getNCharacterStream(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getNCharacterStream:" + parameterName);
            return this.cs.getCharacterStream(parameterName);
        }

        @Override
        public NClob getNClob(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getNClob:" + parameterIndex);
            return this.cs.getNClob(parameterIndex);
        }

        @Override
        public NClob getNClob(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".:getNClob" + parameterName);
            return this.cs.getNClob(parameterName);
        }

        @Override
        public String getNString(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getNString:" + parameterIndex);
            return this.cs.getNString(parameterIndex);
        }

        @Override
        public String getNString(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getNString:" + parameterName);
            return this.cs.getNString(parameterName);
        }

        @Override
        public Object getObject(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getObject:" + parameterIndex);
            return this.cs.getObject(parameterIndex);
        }

        @Override
        public Object getObject(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getObject:" + parameterName);
            return this.cs.getObject(parameterName);
        }

        @Override
        public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getObject:" + parameterIndex + "," + map);
            return this.cs.getObject(parameterIndex, map);
        }

        @Override
        public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getObject:" + parameterName + "," + map);
            return this.cs.getObject(parameterName, map);
        }

        @Override
        public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getObject:" + parameterIndex + "," + type);
            return this.cs.getObject(parameterIndex, type);
        }

        @Override
        public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getObject:" + parameterName + "," + type);
            return this.cs.getObject(parameterName, type);
        }

        @Override
        public Ref getRef(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getRef:" + parameterIndex);
            return this.cs.getRef(parameterIndex);
        }

        @Override
        public Ref getRef(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getRef:" + parameterName);
            return this.cs.getRef(parameterName);
        }

        @Override
        public RowId getRowId(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getRowId:" + parameterIndex);
            return this.cs.getRowId(parameterIndex);
        }

        @Override
        public RowId getRowId(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getRowId:" + parameterName);
            return this.cs.getRowId(parameterName);
        }

        @Override
        public SQLXML getSQLXML(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getSQLXML:" + parameterIndex);
            return this.cs.getSQLXML(parameterIndex);
        }

        @Override
        public SQLXML getSQLXML(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getSQLXML:" + parameterName);
            return this.cs.getSQLXML(parameterName);
        }

        @Override
        public short getShort(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getShort:" + parameterIndex);
            return this.cs.getShort(parameterIndex);
        }

        @Override
        public short getShort(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getShort:" + parameterName);
            return this.cs.getShort(parameterName);
        }

        @Override
        public String getString(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getString:" + parameterIndex);
            return this.cs.getString(parameterIndex);
        }

        @Override
        public String getString(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getString:" + parameterName);
            return this.cs.getString(parameterName);
        }

        @Override
        public Time getTime(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getTime:" + parameterIndex);
            return this.cs.getTime(parameterIndex);
        }

        @Override
        public Time getTime(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getTime:" + parameterName);
            return this.cs.getTime(parameterName);
        }

        @Override
        public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getTime:" + parameterIndex + "," + cal);
            return this.cs.getTime(parameterIndex, cal);
        }

        @Override
        public Time getTime(String parameterName, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".:getTime" + parameterName + "," + cal);
            return this.cs.getTime(parameterName, cal);
        }

        @Override
        public Timestamp getTimestamp(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getTimestamp:" + parameterIndex);
            return this.cs.getTimestamp(parameterIndex);
        }

        @Override
        public Timestamp getTimestamp(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getTimestamp:" + parameterName);
            return this.cs.getTimestamp(parameterName);
        }

        @Override
        public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getTimestamp:" + parameterIndex + "," + cal);
            return this.cs.getTimestamp(parameterIndex, cal);
        }

        @Override
        public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getTimestamp:" + parameterName + "," + cal);
            return this.cs.getTimestamp(parameterName, cal);
        }

        @Override
        public URL getURL(int parameterIndex) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getURL:" + parameterIndex);
            return this.cs.getURL(parameterIndex);
        }

        @Override
        public URL getURL(String parameterName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getURL:" + parameterName);
            return this.cs.getURL(parameterName);
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".registerOutParameter:" + parameterIndex + "," + sqlType);
            this.cs.registerOutParameter(parameterIndex, sqlType);
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".registerOutParameter:" + parameterName + "," + sqlType);
            this.cs.registerOutParameter(parameterName, sqlType);
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".registerOutParameter:" + parameterIndex + "," + sqlType + "," + scale);
            this.cs.registerOutParameter(parameterIndex, sqlType, scale);
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".registerOutParameter:" + parameterIndex + "," + sqlType + "," + typeName);
            this.cs.registerOutParameter(parameterIndex, sqlType, typeName);
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".registerOutParameter:" + parameterName + "," + sqlType + "," + scale);
            this.cs.registerOutParameter(parameterName, sqlType, scale);
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".registerOutParameter:" + parameterName + "," + sqlType + "," + typeName);
            this.cs.registerOutParameter(parameterName, sqlType, typeName);
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setAsciiStream:" + parameterName);
            this.cs.setAsciiStream(parameterName, x);
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setAsciiStream:" + parameterName + "," + length);
            this.cs.setAsciiStream(parameterName, x, length);
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setAsciiStream:" + parameterName + "," + length);
            this.cs.setAsciiStream(parameterName, x, length);
        }

        @Override
        public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBigDecimal:" + parameterName);
            this.cs.setBigDecimal(parameterName, x);
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBinaryStream:" + parameterName);
            this.cs.setBinaryStream(parameterName, x);
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBinaryStream:" + parameterName + "," + length);
            this.cs.setBinaryStream(parameterName, x, length);
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBinaryStream:" + parameterName + "," + length);
            this.cs.setBinaryStream(parameterName, x, length);
        }

        @Override
        public void setBlob(String parameterName, Blob x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBlob:" + parameterName);
            this.cs.setBlob(parameterName, x);
        }

        @Override
        public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBlob:" + parameterName);
            this.cs.setBlob(parameterName, inputStream);
        }

        @Override
        public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBlob:" + parameterName + "," + length);
            this.cs.setBlob(parameterName, inputStream, length);
        }

        @Override
        public void setBoolean(String parameterName, boolean x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBoolean:" + parameterName + "," + x);
            this.cs.setBoolean(parameterName, x);
        }

        @Override
        public void setByte(String parameterName, byte x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setByte:" + parameterName + "," + x);
            this.cs.setByte(parameterName, x);
        }

        @Override
        public void setBytes(String parameterName, byte[] x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBytes:" + parameterName + "," + Arrays.toString(x));
            this.cs.setBytes(parameterName, x);
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setCharacterStream:" + parameterName);
            this.cs.setCharacterStream(parameterName, reader);
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setCharacterStream:" + parameterName + "," + length);
            this.cs.setCharacterStream(parameterName, reader, length);
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setCharacterStream:" + parameterName + "," + length);
            this.cs.setCharacterStream(parameterName, reader, length);
        }

        @Override
        public void setClob(String parameterName, Clob x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setClob:" + parameterName);
            this.cs.setClob(parameterName, x);
        }

        @Override
        public void setClob(String parameterName, Reader reader) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setClob:" + parameterName);
            this.cs.setClob(parameterName, reader);
        }

        @Override
        public void setClob(String parameterName, Reader reader, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setClob:" + parameterName + "," + length);
            this.cs.setClob(parameterName, reader, length);
        }

        @Override
        public void setDate(String parameterName, Date x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setDate:" + parameterName);
            this.cs.setDate(parameterName, x);
        }

        @Override
        public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setDate:" + parameterName + "," + cal);
            this.cs.setDate(parameterName, x, cal);
        }

        @Override
        public void setDouble(String parameterName, double x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setDouble:" + parameterName + "," + x);
            this.cs.setDouble(parameterName, x);
        }

        @Override
        public void setFloat(String parameterName, float x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setFloat:" + parameterName + "," + x);
            this.cs.setFloat(parameterName, x);
        }

        @Override
        public void setInt(String parameterName, int x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setInt:" + parameterName + "," + x);
            this.cs.setInt(parameterName, x);
        }

        @Override
        public void setLong(String parameterName, long x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setLong:" + parameterName + "," + x);
            this.cs.setLong(parameterName, x);
        }

        @Override
        public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNCharacterStream:" + parameterName);
            this.cs.setNCharacterStream(parameterName, value);
        }

        @Override
        public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNCharacterStream:" + parameterName);
            this.cs.setNCharacterStream(parameterName, value, length);
        }

        @Override
        public void setNClob(String parameterName, NClob value) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNClob:" + parameterName);
            this.cs.setNClob(parameterName, value);
        }

        @Override
        public void setNClob(String parameterName, Reader reader) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNClob:" + parameterName);
            this.cs.setNClob(parameterName, reader);
        }

        @Override
        public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNClob:" + parameterName);
            this.cs.setNClob(parameterName, reader, length);
        }

        @Override
        public void setNString(String parameterName, String value) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNString:" + parameterName + "," + value);
            this.cs.setNString(parameterName, value);
        }

        @Override
        public void setNull(String parameterName, int sqlType) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNull:" + parameterName + "," + sqlType);
            this.cs.setNull(parameterName, sqlType);
        }

        @Override
        public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNull:" + parameterName + "," + sqlType + "," + typeName);
            this.cs.setNull(parameterName, sqlType, typeName);
        }

        @Override
        public void setObject(String parameterName, Object x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setObject:" + parameterName);
            this.cs.setObject(parameterName, x);
        }

        @Override
        public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setObject:" + parameterName + "," + targetSqlType);
            this.cs.setObject(parameterName, x, targetSqlType);
        }

        @Override
        public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setObject:" + parameterName + "," + targetSqlType + "," + scale);
            this.cs.setObject(parameterName, x, targetSqlType, scale);
        }

        @Override
        public void setRowId(String parameterName, RowId x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setRowId:" + parameterName);
            this.cs.setRowId(parameterName, x);
        }

        @Override
        public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setSQLXML:" + parameterName);
            this.cs.setSQLXML(parameterName, xmlObject);
        }

        @Override
        public void setShort(String parameterName, short x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setShort:" + parameterName + "," + x);
            this.cs.setShort(parameterName, x);
        }

        @Override
        public void setString(String parameterName, String x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setString:" + parameterName + "," + x);
            this.cs.setString(parameterName, x);
        }

        @Override
        public void setTime(String parameterName, Time x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTime:" + parameterName + "," + x);
            this.cs.setTime(parameterName, x);
        }

        @Override
        public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTime:" + parameterName + "," + x + "," + cal);
            this.cs.setTime(parameterName, x, cal);
        }

        @Override
        public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTimestamp:" + parameterName + "," + x);
            this.cs.setTimestamp(parameterName, x);
        }

        @Override
        public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTimestamp:" + parameterName + "," + x + "," + cal);
            this.cs.setTimestamp(parameterName, x, cal);
        }

        @Override
        public void setURL(String parameterName, URL val) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setURL:" + parameterName + "," + val);
            this.cs.setURL(parameterName, val);
        }

        @Override
        public boolean wasNull() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".wasNull");
            return this.cs.wasNull();
        }
    }

    protected class LoggingPreparedStatement
    extends LoggingStatement
    implements PreparedStatement {
        private final PreparedStatement ps;

        public LoggingPreparedStatement(PreparedStatement preparedStatement) {
            super(preparedStatement);
            this.ps = preparedStatement;
        }

        @Override
        protected String getStatementLogType() {
            return "PreparedStatement";
        }

        @Override
        public void addBatch() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".addBatch");
            this.ps.addBatch();
        }

        @Override
        public void clearParameters() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".clearParameters");
            this.ps.clearParameters();
        }

        @Override
        public boolean execute() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".execute");
            return this.ps.execute();
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeQuery");
            return this.ps.executeQuery();
        }

        @Override
        public int executeUpdate() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeUpdate");
            return this.ps.executeUpdate();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getMetaData");
            return this.ps.getMetaData();
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getParameterMetaData");
            return this.ps.getParameterMetaData();
        }

        @Override
        public void setArray(int parameterIndex, Array x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setArray:" + parameterIndex);
            this.ps.setArray(parameterIndex, x);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setAsciiStream:" + parameterIndex);
            this.ps.setAsciiStream(parameterIndex, x);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setAsciiStream:" + parameterIndex + "," + length);
            this.ps.setAsciiStream(parameterIndex, x, length);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setAsciiStream:" + parameterIndex + "," + length);
            this.ps.setAsciiStream(parameterIndex, x, length);
        }

        @Override
        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBigDecimal:" + parameterIndex + "," + x);
            this.ps.setBigDecimal(parameterIndex, x);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBinaryStream:" + parameterIndex);
            this.ps.setBinaryStream(parameterIndex, x);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBinaryStream:" + parameterIndex + "," + length);
            this.ps.setBinaryStream(parameterIndex, x, length);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBinaryStream:" + parameterIndex + "," + length);
            this.ps.setBinaryStream(parameterIndex, x, length);
        }

        @Override
        public void setBlob(int parameterIndex, Blob x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBlob:" + parameterIndex);
            this.ps.setBlob(parameterIndex, x);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBlob:" + parameterIndex);
            this.ps.setBlob(parameterIndex, inputStream);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBlob:" + parameterIndex + "," + length);
            this.ps.setBlob(parameterIndex, inputStream, length);
        }

        @Override
        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBoolean:" + parameterIndex + "," + x);
            this.ps.setBoolean(parameterIndex, x);
        }

        @Override
        public void setByte(int parameterIndex, byte x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setByte:" + parameterIndex + "," + x);
            this.ps.setByte(parameterIndex, x);
        }

        @Override
        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setBytes:" + parameterIndex + "," + Arrays.toString(x));
            this.ps.setBytes(parameterIndex, x);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setCharacterStream:" + parameterIndex);
            this.ps.setCharacterStream(parameterIndex, reader);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setCharacterStream:" + parameterIndex + "," + length);
            this.ps.setCharacterStream(parameterIndex, reader, length);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setCharacterStream:" + parameterIndex + "," + length);
            this.ps.setCharacterStream(parameterIndex, reader, length);
        }

        @Override
        public void setClob(int parameterIndex, Clob x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setClob:" + parameterIndex);
            this.ps.setClob(parameterIndex, x);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setClob:" + parameterIndex);
            this.ps.setClob(parameterIndex, reader);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setClob:" + parameterIndex + "," + length);
            this.ps.setClob(parameterIndex, reader, length);
        }

        @Override
        public void setDate(int parameterIndex, Date x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setDate:" + parameterIndex + "," + x);
            this.ps.setDate(parameterIndex, x);
        }

        @Override
        public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setDate:" + parameterIndex + "," + x + "," + cal);
            this.ps.setDate(parameterIndex, x, cal);
        }

        @Override
        public void setDouble(int parameterIndex, double x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setDouble:" + parameterIndex + "," + x);
            this.ps.setDouble(parameterIndex, x);
        }

        @Override
        public void setFloat(int parameterIndex, float x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setFloat:" + parameterIndex + "," + x);
            this.ps.setFloat(parameterIndex, x);
        }

        @Override
        public void setInt(int parameterIndex, int x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setInt:" + parameterIndex + "," + x);
            this.ps.setInt(parameterIndex, x);
        }

        @Override
        public void setLong(int parameterIndex, long x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setLong:" + parameterIndex + "," + x);
            this.ps.setLong(parameterIndex, x);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNCharacterStream:" + parameterIndex);
            this.ps.setNCharacterStream(parameterIndex, value);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNCharacterStream:" + parameterIndex + "," + length);
            this.ps.setNCharacterStream(parameterIndex, value, length);
        }

        @Override
        public void setNClob(int parameterIndex, NClob value) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNClob:" + parameterIndex);
            this.ps.setNClob(parameterIndex, value);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNClob:" + parameterIndex);
            this.ps.setNClob(parameterIndex, reader);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNClob:" + parameterIndex + "," + length);
            this.ps.setNClob(parameterIndex, reader, length);
        }

        @Override
        public void setNString(int parameterIndex, String value) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNString:" + parameterIndex + "," + value);
            this.ps.setNString(parameterIndex, value);
        }

        @Override
        public void setNull(int parameterIndex, int sqlType) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNull:" + parameterIndex + "," + sqlType);
            this.ps.setNull(parameterIndex, sqlType);
        }

        @Override
        public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setNull:" + parameterIndex + "," + sqlType + "," + typeName);
            this.ps.setNull(parameterIndex, sqlType, typeName);
        }

        @Override
        public void setObject(int parameterIndex, Object x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setObject:" + parameterIndex);
            this.ps.setObject(parameterIndex, x);
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setObject:" + parameterIndex + "," + targetSqlType);
            this.ps.setObject(parameterIndex, x, targetSqlType);
        }

        @Override
        public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setObject:" + parameterIndex + "," + targetSqlType + "," + scaleOrLength);
            this.ps.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }

        @Override
        public void setRef(int parameterIndex, Ref x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setRef:" + parameterIndex + "," + x);
            this.ps.setRef(parameterIndex, x);
        }

        @Override
        public void setRowId(int parameterIndex, RowId x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setRowId:" + parameterIndex + "," + x);
            this.ps.setRowId(parameterIndex, x);
        }

        @Override
        public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setSQLXML:" + parameterIndex);
            this.ps.setSQLXML(parameterIndex, xmlObject);
        }

        @Override
        public void setShort(int parameterIndex, short x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setShort:" + parameterIndex + "," + x);
            this.ps.setShort(parameterIndex, x);
        }

        @Override
        public void setString(int parameterIndex, String x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setString:" + parameterIndex + "," + x);
            this.ps.setString(parameterIndex, x);
        }

        @Override
        public void setTime(int parameterIndex, Time x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTime:" + parameterIndex);
            this.ps.setTime(parameterIndex, x);
        }

        @Override
        public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTime:" + parameterIndex + "," + cal);
            this.ps.setTime(parameterIndex, x, cal);
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTimestamp:" + parameterIndex + "," + x);
            this.ps.setTimestamp(parameterIndex, x);
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setTimestamp:" + parameterIndex + "," + x + "," + cal);
            this.ps.setTimestamp(parameterIndex, x, cal);
        }

        @Override
        public void setURL(int parameterIndex, URL x) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setURL:" + parameterIndex + "," + x);
            this.ps.setURL(parameterIndex, x);
        }

        @Override
        public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setUnicodeStream:" + parameterIndex + "," + length);
            this.ps.setUnicodeStream(parameterIndex, x, length);
        }
    }

    protected class LoggingStatement
    implements Statement {
        private final Statement s;

        public LoggingStatement(Statement s) {
            this.s = s;
        }

        protected String getStatementLogType() {
            return "Statement";
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".isWrapperFor:" + iface);
            return this.s.isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".unwrap:" + iface);
            return this.s.unwrap(iface);
        }

        @Override
        public void addBatch(String sql) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".addBatch");
            this.s.addBatch(sql);
        }

        @Override
        public void cancel() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".cancel");
            this.s.cancel();
        }

        @Override
        public void clearBatch() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".clearBatch");
            this.s.clearBatch();
        }

        @Override
        public void clearWarnings() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".clearWarnings");
            this.s.clearWarnings();
        }

        @Override
        public void close() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".close");
            this.s.close();
        }

        @Override
        public void closeOnCompletion() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".closeOnCompletion");
            this.s.closeOnCompletion();
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".execute:" + sql);
            return this.s.execute(sql);
        }

        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".execute:" + sql + "," + autoGeneratedKeys);
            return this.s.execute(sql, autoGeneratedKeys);
        }

        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".execute:" + sql + "," + Arrays.toString(columnIndexes));
            return this.s.execute(sql, columnIndexes);
        }

        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".execute:" + sql + "," + Arrays.toString(columnNames));
            return this.s.execute(sql, columnNames);
        }

        @Override
        public int[] executeBatch() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeBatch");
            return this.s.executeBatch();
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeQuery:" + sql);
            return this.s.executeQuery(sql);
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeUpdate:" + sql);
            return this.s.executeUpdate(sql);
        }

        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeUpdate:" + sql + "," + autoGeneratedKeys);
            return this.s.executeUpdate(sql, autoGeneratedKeys);
        }

        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeUpdate:" + sql + "," + Arrays.toString(columnIndexes));
            return this.s.executeUpdate(sql, columnIndexes);
        }

        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".executeUpdate:" + sql + "," + Arrays.toString(columnNames));
            return this.s.executeUpdate(sql, columnNames);
        }

        @Override
        public Connection getConnection() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getConnection");
            return this.s.getConnection();
        }

        @Override
        public int getFetchDirection() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getFetchDirection");
            return this.s.getFetchDirection();
        }

        @Override
        public int getFetchSize() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getFetchSize");
            return this.s.getFetchSize();
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getGeneratedKeys");
            return this.s.getGeneratedKeys();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getMaxFieldSize");
            return this.s.getMaxFieldSize();
        }

        @Override
        public int getMaxRows() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getMaxRows");
            return this.s.getMaxRows();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getMoreResults");
            return this.s.getMoreResults();
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getMoreResults:" + current);
            return this.s.getMoreResults(current);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getQueryTimeout");
            return this.s.getQueryTimeout();
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getResultSet");
            return this.s.getResultSet();
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getResultSetConcurrency");
            return this.s.getResultSetConcurrency();
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getResultSetHoldability");
            return this.s.getResultSetHoldability();
        }

        @Override
        public int getResultSetType() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getResultSetType");
            return this.s.getResultSetType();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getUpdateCount");
            return this.s.getUpdateCount();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".getWarnings");
            return this.s.getWarnings();
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".isCloseOnCompletion");
            return this.s.isCloseOnCompletion();
        }

        @Override
        public boolean isClosed() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".isClosed");
            return this.s.isClosed();
        }

        @Override
        public boolean isPoolable() throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".isPoolable");
            return this.s.isPoolable();
        }

        @Override
        public void setCursorName(String name) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setCursorName:" + name);
            this.s.setCursorName(name);
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setEscapeProcessing:" + enable);
            this.s.setEscapeProcessing(enable);
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setFetchDirection:" + direction);
            this.s.setFetchDirection(direction);
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setFetchSize:" + rows);
            this.s.setFetchSize(rows);
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setMaxFieldSize:" + max);
            this.s.setMaxFieldSize(max);
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setMaxRows:" + max);
            this.s.setMaxRows(max);
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setPoolable:" + poolable);
            this.s.setPoolable(poolable);
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
            LoggingDriver.this.log(this.getStatementLogType() + ".setQueryTimeout:" + seconds);
            this.s.setQueryTimeout(seconds);
        }
    }

    protected class LoggingConnection
    implements Connection {
        private final Connection delegateConnection;

        public LoggingConnection(Connection delegateConnection) throws SQLException {
            this.delegateConnection = delegateConnection;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            LoggingDriver.this.log("unwarp:" + iface);
            return this.delegateConnection.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            LoggingDriver.this.log("isWrapperFor:" + iface);
            return this.delegateConnection.isWrapperFor(iface);
        }

        @Override
        public Statement createStatement() throws SQLException {
            LoggingDriver.this.log("createStatement");
            return this.delegateConnection.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            LoggingDriver.this.log("prepareStatement:" + sql);
            return new LoggingPreparedStatement(this.delegateConnection.prepareStatement(sql));
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            LoggingDriver.this.log("prepareCall:" + sql);
            return new LoggingCallableStatement(this.delegateConnection.prepareCall(sql));
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            LoggingDriver.this.log("nativeSQL:" + sql);
            return this.delegateConnection.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            LoggingDriver.this.log("setAutoCommit:" + autoCommit);
            this.delegateConnection.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            LoggingDriver.this.log("getAutoCommit");
            return this.delegateConnection.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            LoggingDriver.this.log("commit");
            this.delegateConnection.commit();
        }

        @Override
        public void rollback() throws SQLException {
            LoggingDriver.this.log("rollback");
            this.delegateConnection.rollback();
        }

        @Override
        public void close() throws SQLException {
            LoggingDriver.this.log("close");
            this.delegateConnection.close();
        }

        @Override
        public boolean isClosed() throws SQLException {
            LoggingDriver.this.log("isClosed");
            return this.delegateConnection.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            LoggingDriver.this.log("getMetaData");
            return this.delegateConnection.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            LoggingDriver.this.log("setReadOnly:" + readOnly);
            this.delegateConnection.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            LoggingDriver.this.log("isReadOnly");
            return this.delegateConnection.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            LoggingDriver.this.log("setCatalog:" + catalog);
            this.delegateConnection.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            LoggingDriver.this.log("getCatalog");
            return this.delegateConnection.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            LoggingDriver.this.log("setTransactionIsolation:" + level);
            this.delegateConnection.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            LoggingDriver.this.log("getTransactionIsolation");
            return this.delegateConnection.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            LoggingDriver.this.log("getWarnings");
            return this.delegateConnection.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            LoggingDriver.this.log("clearWarnings");
            this.delegateConnection.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            LoggingDriver.this.log("createStatement:" + resultSetType + ";" + resultSetConcurrency);
            return new LoggingStatement(this.delegateConnection.createStatement(resultSetType, resultSetConcurrency));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            LoggingDriver.this.log("prepareStatement:" + sql + ";" + resultSetType + ";" + resultSetConcurrency);
            return new LoggingPreparedStatement(this.delegateConnection.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            LoggingDriver.this.log("prepareCall:" + sql + ";" + resultSetType + ";" + resultSetConcurrency);
            return new LoggingCallableStatement(this.delegateConnection.prepareCall(sql, resultSetType, resultSetConcurrency));
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            LoggingDriver.this.log("getTypeMap");
            return this.delegateConnection.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            LoggingDriver.this.log("setTypeMap:" + map);
            this.delegateConnection.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            LoggingDriver.this.log("setHoldability:" + holdability);
            this.delegateConnection.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            LoggingDriver.this.log("getHoldability");
            return this.delegateConnection.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            LoggingDriver.this.log("setSavepoint");
            return this.delegateConnection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            LoggingDriver.this.log("setSavepoint:" + name);
            return this.delegateConnection.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            LoggingDriver.this.log("rollback:" + savepoint);
            this.delegateConnection.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            LoggingDriver.this.log("releaseSavepoint:" + savepoint);
            this.delegateConnection.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            LoggingDriver.this.log("createStatement:" + resultSetType + ";" + resultSetConcurrency + ";" + resultSetHoldability);
            return new LoggingStatement(this.delegateConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            LoggingDriver.this.log("prepareStatement:" + sql + ";" + resultSetType + ";" + resultSetConcurrency + ";" + resultSetHoldability);
            return new LoggingPreparedStatement(this.delegateConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            LoggingDriver.this.log("prepareCall:" + sql + ";" + resultSetType + ";" + resultSetConcurrency + ";" + resultSetHoldability);
            return new LoggingCallableStatement(this.delegateConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            LoggingDriver.this.log("prepareStatement:" + sql + ";" + autoGeneratedKeys);
            return new LoggingPreparedStatement(this.delegateConnection.prepareStatement(sql, autoGeneratedKeys));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            LoggingDriver.this.log("prepareStatement:" + sql + ";" + Arrays.toString(columnIndexes));
            return new LoggingPreparedStatement(this.delegateConnection.prepareStatement(sql, columnIndexes));
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            LoggingDriver.this.log("prepareStatement:" + sql + ";" + Arrays.toString(columnNames));
            return new LoggingPreparedStatement(this.delegateConnection.prepareStatement(sql, columnNames));
        }

        @Override
        public Clob createClob() throws SQLException {
            LoggingDriver.this.log("createClob");
            return this.delegateConnection.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            LoggingDriver.this.log("createBlob");
            return this.delegateConnection.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            LoggingDriver.this.log("createNClob");
            return this.delegateConnection.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            LoggingDriver.this.log("createSQLXML");
            return this.delegateConnection.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            LoggingDriver.this.log("isValid:" + timeout);
            return this.delegateConnection.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            LoggingDriver.this.log("setClientInfo:" + name + ";" + value);
            this.delegateConnection.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            LoggingDriver.this.log("setClientInfo:" + properties);
            this.delegateConnection.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            LoggingDriver.this.log("getClientInfo:" + name);
            return this.delegateConnection.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            LoggingDriver.this.log("getClientInfo");
            return this.delegateConnection.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            LoggingDriver.this.log("createArrayOf:" + typeName + ";" + Arrays.deepToString(elements));
            return this.delegateConnection.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            LoggingDriver.this.log("createStruct:" + typeName + ";" + Arrays.toString(attributes));
            return this.delegateConnection.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            LoggingDriver.this.log("setSchema");
            this.delegateConnection.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            LoggingDriver.this.log("getSchema");
            return this.delegateConnection.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            LoggingDriver.this.log("abort:" + (executor == null ? null : executor.getClass()));
            this.delegateConnection.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            LoggingDriver.this.log("setNetworkTimeout:" + (executor == null ? null : executor.getClass()) + ";" + milliseconds);
            this.delegateConnection.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            LoggingDriver.this.log("getNetworkTimeout");
            return this.delegateConnection.getNetworkTimeout();
        }
    }
}

