/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.db.aurora;

import java.util.Properties;

public class AuroraServer
implements Comparable<AuroraServer> {
    private static final int DEFAULT_PORT = 3306;
    private final String host;
    private final int port;
    private final Properties info;
    private final int hashCode;

    public AuroraServer(String server, Properties info) {
        int delim = server.indexOf(58);
        if (delim > 0) {
            this.host = server.substring(0, delim).intern();
            this.port = Integer.parseInt(server.substring(delim + 1));
        } else {
            this.host = server.intern();
            this.port = 3306;
        }
        this.info = info;
        this.hashCode = this.host.hashCode() ^ this.port;
    }

    public AuroraServer(String host, int port, Properties info) {
        this.host = host.intern();
        this.port = port;
        this.info = info;
        this.hashCode = host.hashCode() ^ port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AuroraServer) {
            AuroraServer as = (AuroraServer)o;
            if (!this.host.equals(as.host)) {
                return false;
            }
            return this.port == as.port;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(AuroraServer as) {
        int hostCompare = this.host.compareTo(as.host);
        if (hostCompare == 0) {
            return this.port - as.port;
        }
        return hostCompare;
    }

    public String hostAndPortString() {
        return this.host + ":" + this.port;
    }

    public String toString() {
        return this.hostAndPortString();
    }

    public Properties getProperties() {
        return this.info;
    }
}

