/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.db;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractDelegatingConnection
implements Connection {
    protected abstract <R> R processOnDelegate(SQLOperation<Connection, R> var1) throws SQLException;

    protected abstract Connection getReferenceConnection();

    protected abstract void resetStickyConnection();

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLException("Unable to unwrap to " + iface, e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public void commit() throws SQLException {
        this.processOnDelegate(c -> {
            c.commit();
            return null;
        });
        this.resetStickyConnection();
    }

    @Override
    public void rollback() throws SQLException {
        this.processOnDelegate(c -> {
            c.rollback();
            return null;
        });
        this.resetStickyConnection();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.processOnDelegate(c -> {
            c.rollback(savepoint);
            return null;
        });
        this.resetStickyConnection();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.processOnDelegate(c -> c.setSavepoint());
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.processOnDelegate(c -> c.setSavepoint(name));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.processOnDelegate(c -> {
            c.releaseSavepoint(savepoint);
            return null;
        });
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DelegatingStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DelegatingStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DelegatingStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DelegatingPreparedStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DelegatingPreparedStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DelegatingPreparedStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DelegatingPreparedStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DelegatingPreparedStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DelegatingPreparedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new DelegatingCallableStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DelegatingCallableStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DelegatingCallableStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.getReferenceConnection().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.getReferenceConnection().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.getReferenceConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.getReferenceConnection().createSQLXML();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getReferenceConnection().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getReferenceConnection().getClientInfo();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getReferenceConnection().getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getReferenceConnection().getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getReferenceConnection().getMetaData();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.getReferenceConnection().getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getReferenceConnection().getSchema();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getReferenceConnection().getTypeMap();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.getReferenceConnection().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.getReferenceConnection().createStruct(typeName, attributes);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getReferenceConnection().nativeSQL(sql);
    }

    protected class DelegatingCallableStatement
    extends AbstractDelegatingStatement<CallableStatement>
    implements CallableStatement {
        private final SQLOperation<Connection, CallableStatement> delegateStatementProvider;

        public DelegatingCallableStatement(String sql) {
            this.delegateStatementProvider = c -> c.prepareCall(sql);
        }

        public DelegatingCallableStatement(String sql, int resultSetType, int resultSetConcurrency) {
            super(resultSetType, resultSetConcurrency);
            this.delegateStatementProvider = c -> c.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        public DelegatingCallableStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            super(resultSetType, resultSetConcurrency, resultSetHoldability);
            this.delegateStatementProvider = c -> c.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        protected SQLOperation<Connection, CallableStatement> delegateStatementProvider() {
            return this.delegateStatementProvider;
        }

        @Override
        public void addBatch() throws SQLException {
            this.action(ps -> {
                ps.addBatch();
                return null;
            });
        }

        @Override
        public void clearParameters() throws SQLException {
            this.action(ps -> {
                ps.clearParameters();
                return null;
            });
        }

        @Override
        public boolean execute() throws SQLException {
            return ((CallableStatement)this.delegate()).execute();
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            return ((CallableStatement)this.delegate()).executeQuery();
        }

        @Override
        public int executeUpdate() throws SQLException {
            return ((CallableStatement)this.delegate()).executeUpdate();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return ((CallableStatement)this.delegate()).getMetaData();
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            return ((CallableStatement)this.delegate()).getParameterMetaData();
        }

        @Override
        public void setArray(int arg0, Array arg1) throws SQLException {
            this.action(ps -> {
                ps.setArray(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
            this.action(ps -> {
                ps.setAsciiStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setAsciiStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setAsciiStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
            this.action(ps -> {
                ps.setBigDecimal(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
            this.action(ps -> {
                ps.setBinaryStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setBinaryStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setBinaryStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setBlob(int arg0, Blob arg1) throws SQLException {
            this.action(ps -> {
                ps.setBlob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBlob(int arg0, InputStream arg1) throws SQLException {
            this.action(ps -> {
                ps.setBlob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setBlob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBoolean(int arg0, boolean arg1) throws SQLException {
            this.action(ps -> {
                ps.setBoolean(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setByte(int arg0, byte arg1) throws SQLException {
            this.action(ps -> {
                ps.setByte(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBytes(int arg0, byte[] arg1) throws SQLException {
            this.action(ps -> {
                ps.setBytes(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setCharacterStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setCharacterStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setCharacterStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setClob(int arg0, Clob arg1) throws SQLException {
            this.action(ps -> {
                ps.setClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setClob(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setClob(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setDate(int arg0, Date arg1) throws SQLException {
            this.action(ps -> {
                ps.setDate(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
            this.action(ps -> {
                ps.setDate(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setDouble(int arg0, double arg1) throws SQLException {
            this.action(ps -> {
                ps.setDouble(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setFloat(int arg0, float arg1) throws SQLException {
            this.action(ps -> {
                ps.setFloat(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setInt(int arg0, int arg1) throws SQLException {
            this.action(ps -> {
                ps.setInt(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setLong(int arg0, long arg1) throws SQLException {
            this.action(ps -> {
                ps.setLong(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setNCharacterStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setNCharacterStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setNClob(int arg0, NClob arg1) throws SQLException {
            this.action(ps -> {
                ps.setNClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNClob(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setNClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setNClob(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setNString(int arg0, String arg1) throws SQLException {
            this.action(ps -> {
                ps.setNString(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNull(int arg0, int arg1) throws SQLException {
            this.action(ps -> {
                ps.setNull(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNull(int arg0, int arg1, String arg2) throws SQLException {
            this.action(ps -> {
                ps.setNull(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setObject(int arg0, Object arg1) throws SQLException {
            this.action(ps -> {
                ps.setObject(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setObject(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
            this.action(ps -> {
                ps.setObject(arg0, arg1, arg2, arg3);
                return null;
            });
        }

        @Override
        public void setRef(int arg0, Ref arg1) throws SQLException {
            this.action(ps -> {
                ps.setRef(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setRowId(int arg0, RowId arg1) throws SQLException {
            this.action(ps -> {
                ps.setRowId(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
            this.action(ps -> {
                ps.setSQLXML(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setShort(int arg0, short arg1) throws SQLException {
            this.action(ps -> {
                ps.setShort(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setString(int arg0, String arg1) throws SQLException {
            this.action(ps -> {
                ps.setString(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setTime(int arg0, Time arg1) throws SQLException {
            this.action(ps -> {
                ps.setTime(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
            this.action(ps -> {
                ps.setTime(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
            this.action(ps -> {
                ps.setTimestamp(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            this.action(ps -> {
                ps.setTimestamp(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setURL(int arg0, URL arg1) throws SQLException {
            this.action(ps -> {
                ps.setURL(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setUnicodeStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public Array getArray(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getArray(parameterIndex);
        }

        @Override
        public Array getArray(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getArray(parameterName);
        }

        @Override
        public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getBigDecimal(parameterIndex);
        }

        @Override
        public BigDecimal getBigDecimal(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getBigDecimal(parameterName);
        }

        @Override
        public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
            return ((CallableStatement)this.delegate()).getBigDecimal(parameterIndex, scale);
        }

        @Override
        public Blob getBlob(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getBlob(parameterIndex);
        }

        @Override
        public Blob getBlob(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getBlob(parameterName);
        }

        @Override
        public boolean getBoolean(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getBoolean(parameterIndex);
        }

        @Override
        public boolean getBoolean(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getBoolean(parameterName);
        }

        @Override
        public byte getByte(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getByte(parameterIndex);
        }

        @Override
        public byte getByte(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getByte(parameterName);
        }

        @Override
        public byte[] getBytes(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getBytes(parameterIndex);
        }

        @Override
        public byte[] getBytes(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getBytes(parameterName);
        }

        @Override
        public Reader getCharacterStream(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getCharacterStream(parameterIndex);
        }

        @Override
        public Reader getCharacterStream(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getCharacterStream(parameterName);
        }

        @Override
        public Clob getClob(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getClob(parameterIndex);
        }

        @Override
        public Clob getClob(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getClob(parameterName);
        }

        @Override
        public Date getDate(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getDate(parameterIndex);
        }

        @Override
        public Date getDate(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getDate(parameterName);
        }

        @Override
        public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
            return ((CallableStatement)this.delegate()).getDate(parameterIndex, cal);
        }

        @Override
        public Date getDate(String parameterName, Calendar cal) throws SQLException {
            return ((CallableStatement)this.delegate()).getDate(parameterName, cal);
        }

        @Override
        public double getDouble(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getDouble(parameterIndex);
        }

        @Override
        public double getDouble(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getDouble(parameterName);
        }

        @Override
        public float getFloat(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getFloat(parameterIndex);
        }

        @Override
        public float getFloat(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getFloat(parameterName);
        }

        @Override
        public int getInt(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getInt(parameterIndex);
        }

        @Override
        public int getInt(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getInt(parameterName);
        }

        @Override
        public long getLong(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getLong(parameterIndex);
        }

        @Override
        public long getLong(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getLong(parameterName);
        }

        @Override
        public Reader getNCharacterStream(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getNCharacterStream(parameterIndex);
        }

        @Override
        public Reader getNCharacterStream(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getNCharacterStream(parameterName);
        }

        @Override
        public NClob getNClob(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getNClob(parameterIndex);
        }

        @Override
        public NClob getNClob(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getNClob(parameterName);
        }

        @Override
        public String getNString(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getNString(parameterIndex);
        }

        @Override
        public String getNString(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getNString(parameterName);
        }

        @Override
        public Object getObject(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getObject(parameterIndex);
        }

        @Override
        public Object getObject(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getObject(parameterName);
        }

        @Override
        public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
            return ((CallableStatement)this.delegate()).getObject(parameterIndex, map);
        }

        @Override
        public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
            return ((CallableStatement)this.delegate()).getObject(parameterName, map);
        }

        @Override
        public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
            return ((CallableStatement)this.delegate()).getObject(parameterIndex, type);
        }

        @Override
        public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
            return ((CallableStatement)this.delegate()).getObject(parameterName, type);
        }

        @Override
        public Ref getRef(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getRef(parameterIndex);
        }

        @Override
        public Ref getRef(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getRef(parameterName);
        }

        @Override
        public RowId getRowId(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getRowId(parameterIndex);
        }

        @Override
        public RowId getRowId(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getRowId(parameterName);
        }

        @Override
        public SQLXML getSQLXML(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getSQLXML(parameterIndex);
        }

        @Override
        public SQLXML getSQLXML(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getSQLXML(parameterName);
        }

        @Override
        public short getShort(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getShort(parameterIndex);
        }

        @Override
        public short getShort(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getShort(parameterName);
        }

        @Override
        public String getString(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getString(parameterIndex);
        }

        @Override
        public String getString(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getString(parameterName);
        }

        @Override
        public Time getTime(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getTime(parameterIndex);
        }

        @Override
        public Time getTime(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getTime(parameterName);
        }

        @Override
        public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
            return ((CallableStatement)this.delegate()).getTime(parameterIndex, cal);
        }

        @Override
        public Time getTime(String parameterName, Calendar cal) throws SQLException {
            return ((CallableStatement)this.delegate()).getTime(parameterName, cal);
        }

        @Override
        public Timestamp getTimestamp(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getTimestamp(parameterIndex);
        }

        @Override
        public Timestamp getTimestamp(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getTimestamp(parameterName);
        }

        @Override
        public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
            return ((CallableStatement)this.delegate()).getTimestamp(parameterIndex, cal);
        }

        @Override
        public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
            return ((CallableStatement)this.delegate()).getTimestamp(parameterName, cal);
        }

        @Override
        public URL getURL(int parameterIndex) throws SQLException {
            return ((CallableStatement)this.delegate()).getURL(parameterIndex);
        }

        @Override
        public URL getURL(String parameterName) throws SQLException {
            return ((CallableStatement)this.delegate()).getURL(parameterName);
        }

        @Override
        public boolean wasNull() throws SQLException {
            return ((CallableStatement)this.delegate()).wasNull();
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
            this.action(cs -> {
                cs.registerOutParameter(parameterIndex, sqlType);
                return null;
            });
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
            this.action(cs -> {
                cs.registerOutParameter(parameterName, sqlType);
                return null;
            });
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
            this.action(cs -> {
                cs.registerOutParameter(parameterIndex, sqlType, scale);
                return null;
            });
        }

        @Override
        public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
            this.action(cs -> {
                cs.registerOutParameter(parameterIndex, sqlType, typeName);
                return null;
            });
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
            this.action(cs -> {
                cs.registerOutParameter(parameterName, sqlType, scale);
                return null;
            });
        }

        @Override
        public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
            this.action(cs -> {
                cs.registerOutParameter(parameterName, sqlType, typeName);
                return null;
            });
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
            this.action(cs -> {
                cs.setAsciiStream(parameterName, x);
                return null;
            });
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
            this.action(cs -> {
                cs.setAsciiStream(parameterName, x, length);
                return null;
            });
        }

        @Override
        public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
            this.action(cs -> {
                cs.setAsciiStream(parameterName, x, length);
                return null;
            });
        }

        @Override
        public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
            this.action(cs -> {
                cs.setBigDecimal(parameterName, x);
                return null;
            });
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
            this.action(cs -> {
                cs.setBinaryStream(parameterName, x);
                return null;
            });
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
            this.action(cs -> {
                cs.setBinaryStream(parameterName, x, length);
                return null;
            });
        }

        @Override
        public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
            this.action(cs -> {
                cs.setBinaryStream(parameterName, x, length);
                return null;
            });
        }

        @Override
        public void setBlob(String parameterName, Blob x) throws SQLException {
            this.action(cs -> {
                cs.setBlob(parameterName, x);
                return null;
            });
        }

        @Override
        public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
            this.action(cs -> {
                cs.setBlob(parameterName, inputStream);
                return null;
            });
        }

        @Override
        public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
            this.action(cs -> {
                cs.setBlob(parameterName, inputStream, length);
                return null;
            });
        }

        @Override
        public void setBoolean(String parameterName, boolean x) throws SQLException {
            this.action(cs -> {
                cs.setBoolean(parameterName, x);
                return null;
            });
        }

        @Override
        public void setByte(String parameterName, byte x) throws SQLException {
            this.action(cs -> {
                cs.setByte(parameterName, x);
                return null;
            });
        }

        @Override
        public void setBytes(String parameterName, byte[] x) throws SQLException {
            this.action(cs -> {
                cs.setBytes(parameterName, x);
                return null;
            });
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
            this.action(cs -> {
                cs.setCharacterStream(parameterName, reader);
                return null;
            });
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
            this.action(cs -> {
                cs.setCharacterStream(parameterName, reader, length);
                return null;
            });
        }

        @Override
        public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
            this.action(cs -> {
                cs.setCharacterStream(parameterName, reader, length);
                return null;
            });
        }

        @Override
        public void setClob(String parameterName, Clob x) throws SQLException {
            this.action(cs -> {
                cs.setClob(parameterName, x);
                return null;
            });
        }

        @Override
        public void setClob(String parameterName, Reader reader) throws SQLException {
            this.action(cs -> {
                cs.setClob(parameterName, reader);
                return null;
            });
        }

        @Override
        public void setClob(String parameterName, Reader reader, long length) throws SQLException {
            this.action(cs -> {
                cs.setClob(parameterName, reader, length);
                return null;
            });
        }

        @Override
        public void setDate(String parameterName, Date x) throws SQLException {
            this.action(cs -> {
                cs.setDate(parameterName, x);
                return null;
            });
        }

        @Override
        public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
            this.action(cs -> {
                cs.setDate(parameterName, x, cal);
                return null;
            });
        }

        @Override
        public void setDouble(String parameterName, double x) throws SQLException {
            this.action(cs -> {
                cs.setDouble(parameterName, x);
                return null;
            });
        }

        @Override
        public void setFloat(String parameterName, float x) throws SQLException {
            this.action(cs -> {
                cs.setFloat(parameterName, x);
                return null;
            });
        }

        @Override
        public void setInt(String parameterName, int x) throws SQLException {
            this.action(cs -> {
                cs.setInt(parameterName, x);
                return null;
            });
        }

        @Override
        public void setLong(String parameterName, long x) throws SQLException {
            this.action(cs -> {
                cs.setLong(parameterName, x);
                return null;
            });
        }

        @Override
        public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
            this.action(cs -> {
                cs.setNCharacterStream(parameterName, value);
                return null;
            });
        }

        @Override
        public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
            this.action(cs -> {
                cs.setNCharacterStream(parameterName, value, length);
                return null;
            });
        }

        @Override
        public void setNClob(String parameterName, NClob value) throws SQLException {
            this.action(cs -> {
                cs.setNClob(parameterName, value);
                return null;
            });
        }

        @Override
        public void setNClob(String parameterName, Reader reader) throws SQLException {
            this.action(cs -> {
                cs.setNClob(parameterName, reader);
                return null;
            });
        }

        @Override
        public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
            this.action(cs -> {
                cs.setNClob(parameterName, reader, length);
                return null;
            });
        }

        @Override
        public void setNString(String parameterName, String value) throws SQLException {
            this.action(cs -> {
                cs.setNString(parameterName, value);
                return null;
            });
        }

        @Override
        public void setNull(String parameterName, int sqlType) throws SQLException {
            this.action(cs -> {
                cs.setNull(parameterName, sqlType);
                return null;
            });
        }

        @Override
        public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
            this.action(cs -> {
                cs.setNull(parameterName, sqlType, typeName);
                return null;
            });
        }

        @Override
        public void setObject(String parameterName, Object x) throws SQLException {
            this.action(cs -> {
                cs.setObject(parameterName, x);
                return null;
            });
        }

        @Override
        public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
            this.action(cs -> {
                cs.setObject(parameterName, x, targetSqlType);
                return null;
            });
        }

        @Override
        public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
            this.action(cs -> {
                cs.setObject(parameterName, x, targetSqlType, scale);
                return null;
            });
        }

        @Override
        public void setRowId(String parameterName, RowId x) throws SQLException {
            this.action(cs -> {
                cs.setRowId(parameterName, x);
                return null;
            });
        }

        @Override
        public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
            this.action(cs -> {
                cs.setSQLXML(parameterName, xmlObject);
                return null;
            });
        }

        @Override
        public void setShort(String parameterName, short x) throws SQLException {
            this.action(cs -> {
                cs.setShort(parameterName, x);
                return null;
            });
        }

        @Override
        public void setString(String parameterName, String x) throws SQLException {
            this.action(cs -> {
                cs.setString(parameterName, x);
                return null;
            });
        }

        @Override
        public void setTime(String parameterName, Time x) throws SQLException {
            this.action(cs -> {
                cs.setTime(parameterName, x);
                return null;
            });
        }

        @Override
        public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
            this.action(cs -> {
                cs.setTime(parameterName, x, cal);
                return null;
            });
        }

        @Override
        public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
            this.action(cs -> {
                cs.setTimestamp(parameterName, x);
                return null;
            });
        }

        @Override
        public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
            this.action(cs -> {
                cs.setTimestamp(parameterName, x, cal);
                return null;
            });
        }

        @Override
        public void setURL(String parameterName, URL val) throws SQLException {
            this.action(cs -> {
                cs.setURL(parameterName, val);
                return null;
            });
        }
    }

    protected class DelegatingPreparedStatement
    extends AbstractDelegatingStatement<PreparedStatement>
    implements PreparedStatement {
        private final SQLOperation<Connection, PreparedStatement> delegateStatementProvider;

        public DelegatingPreparedStatement(String sql) {
            this.delegateStatementProvider = c -> c.prepareStatement(sql);
        }

        public DelegatingPreparedStatement(String sql, int[] columnIndexes) {
            this.delegateStatementProvider = c -> c.prepareStatement(sql, columnIndexes);
        }

        public DelegatingPreparedStatement(String sql, String[] columnNames) {
            this.delegateStatementProvider = c -> c.prepareStatement(sql, columnNames);
        }

        public DelegatingPreparedStatement(String sql, int autoGeneratedKeys) {
            this.delegateStatementProvider = c -> c.prepareStatement(sql, autoGeneratedKeys);
        }

        public DelegatingPreparedStatement(String sql, int resultSetType, int resultSetConcurrency) {
            super(resultSetType, resultSetConcurrency);
            this.delegateStatementProvider = c -> c.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        public DelegatingPreparedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            super(resultSetType, resultSetConcurrency, resultSetHoldability);
            this.delegateStatementProvider = c -> c.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        protected SQLOperation<Connection, PreparedStatement> delegateStatementProvider() {
            return this.delegateStatementProvider;
        }

        @Override
        public void addBatch() throws SQLException {
            this.action(ps -> {
                ps.addBatch();
                return null;
            });
        }

        @Override
        public void clearParameters() throws SQLException {
            this.action(ps -> {
                ps.clearParameters();
                return null;
            });
        }

        @Override
        public boolean execute() throws SQLException {
            return ((PreparedStatement)this.delegate()).execute();
        }

        @Override
        public ResultSet executeQuery() throws SQLException {
            return ((PreparedStatement)this.delegate()).executeQuery();
        }

        @Override
        public int executeUpdate() throws SQLException {
            return ((PreparedStatement)this.delegate()).executeUpdate();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return ((PreparedStatement)this.delegate()).getMetaData();
        }

        @Override
        public ParameterMetaData getParameterMetaData() throws SQLException {
            return ((PreparedStatement)this.delegate()).getParameterMetaData();
        }

        @Override
        public void setArray(int arg0, Array arg1) throws SQLException {
            this.action(ps -> {
                ps.setArray(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
            this.action(ps -> {
                ps.setAsciiStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setAsciiStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setAsciiStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
            this.action(ps -> {
                ps.setBigDecimal(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
            this.action(ps -> {
                ps.setBinaryStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setBinaryStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setBinaryStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setBlob(int arg0, Blob arg1) throws SQLException {
            this.action(ps -> {
                ps.setBlob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBlob(int arg0, InputStream arg1) throws SQLException {
            this.action(ps -> {
                ps.setBlob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setBlob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBoolean(int arg0, boolean arg1) throws SQLException {
            this.action(ps -> {
                ps.setBoolean(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setByte(int arg0, byte arg1) throws SQLException {
            this.action(ps -> {
                ps.setByte(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setBytes(int arg0, byte[] arg1) throws SQLException {
            this.action(ps -> {
                ps.setBytes(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setCharacterStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setCharacterStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setCharacterStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setClob(int arg0, Clob arg1) throws SQLException {
            this.action(ps -> {
                ps.setClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setClob(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setClob(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setDate(int arg0, Date arg1) throws SQLException {
            this.action(ps -> {
                ps.setDate(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
            this.action(ps -> {
                ps.setDate(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setDouble(int arg0, double arg1) throws SQLException {
            this.action(ps -> {
                ps.setDouble(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setFloat(int arg0, float arg1) throws SQLException {
            this.action(ps -> {
                ps.setFloat(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setInt(int arg0, int arg1) throws SQLException {
            this.action(ps -> {
                ps.setInt(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setLong(int arg0, long arg1) throws SQLException {
            this.action(ps -> {
                ps.setLong(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setNCharacterStream(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setNCharacterStream(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setNClob(int arg0, NClob arg1) throws SQLException {
            this.action(ps -> {
                ps.setNClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNClob(int arg0, Reader arg1) throws SQLException {
            this.action(ps -> {
                ps.setNClob(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
            this.action(ps -> {
                ps.setNClob(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setNString(int arg0, String arg1) throws SQLException {
            this.action(ps -> {
                ps.setNString(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNull(int arg0, int arg1) throws SQLException {
            this.action(ps -> {
                ps.setNull(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setNull(int arg0, int arg1, String arg2) throws SQLException {
            this.action(ps -> {
                ps.setNull(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setObject(int arg0, Object arg1) throws SQLException {
            this.action(ps -> {
                ps.setObject(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setObject(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
            this.action(ps -> {
                ps.setObject(arg0, arg1, arg2, arg3);
                return null;
            });
        }

        @Override
        public void setRef(int arg0, Ref arg1) throws SQLException {
            this.action(ps -> {
                ps.setRef(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setRowId(int arg0, RowId arg1) throws SQLException {
            this.action(ps -> {
                ps.setRowId(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
            this.action(ps -> {
                ps.setSQLXML(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setShort(int arg0, short arg1) throws SQLException {
            this.action(ps -> {
                ps.setShort(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setString(int arg0, String arg1) throws SQLException {
            this.action(ps -> {
                ps.setString(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setTime(int arg0, Time arg1) throws SQLException {
            this.action(ps -> {
                ps.setTime(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
            this.action(ps -> {
                ps.setTime(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
            this.action(ps -> {
                ps.setTimestamp(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            this.action(ps -> {
                ps.setTimestamp(arg0, arg1, arg2);
                return null;
            });
        }

        @Override
        public void setURL(int arg0, URL arg1) throws SQLException {
            this.action(ps -> {
                ps.setURL(arg0, arg1);
                return null;
            });
        }

        @Override
        public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
            this.action(ps -> {
                ps.setUnicodeStream(arg0, arg1, arg2);
                return null;
            });
        }
    }

    protected class DelegatingStatement
    extends AbstractDelegatingStatement<Statement> {
        public DelegatingStatement() {
        }

        public DelegatingStatement(int resultSetType, int resultSetConcurrency) {
            super(resultSetType, resultSetConcurrency);
        }

        public DelegatingStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            super(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        protected SQLOperation<Connection, Statement> delegateStatementProvider() {
            if (this.resultSetHoldability == 1) {
                return c -> c.createStatement(this.resultSetType, this.resultSetConcurrency);
            }
            return c -> c.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        }
    }

    protected abstract class AbstractDelegatingStatement<ST extends Statement>
    implements Statement {
        protected final int resultSetType;
        protected final int resultSetConcurrency;
        protected final int resultSetHoldability;
        private List<SQLOperation<ST, Void>> queuedStatementActions = null;
        private ST delegateStatement = null;

        public AbstractDelegatingStatement() {
            this(1003, 1007);
        }

        public AbstractDelegatingStatement(int resultSetType, int resultSetConcurrency) {
            this(resultSetType, resultSetConcurrency, 1);
        }

        protected AbstractDelegatingStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            this.resultSetType = resultSetType;
            this.resultSetConcurrency = resultSetConcurrency;
            this.resultSetHoldability = resultSetHoldability;
        }

        protected abstract SQLOperation<Connection, ST> delegateStatementProvider();

        protected ST delegate() throws SQLException {
            if (this.delegateStatement == null) {
                this.delegateStatement = (Statement)AbstractDelegatingConnection.this.processOnDelegate(this.delegateStatementProvider());
                if (this.queuedStatementActions != null) {
                    for (SQLOperation<ST, Void> o : this.queuedStatementActions) {
                        o.run(this.delegateStatement);
                    }
                    this.queuedStatementActions = null;
                }
            }
            return this.delegateStatement;
        }

        protected void action(SQLOperation<ST, Void> action) throws SQLException {
            if (this.delegateStatement == null) {
                if (this.queuedStatementActions == null) {
                    this.queuedStatementActions = new ArrayList<SQLOperation<ST, Void>>(2);
                }
                this.queuedStatementActions.add(action);
            } else {
                action.run(this.delegateStatement);
            }
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException e) {
                throw new SQLException("Unable to unwrap to " + iface, e);
            }
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isInstance(this);
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            return this.resultSetConcurrency;
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            return this.resultSetHoldability;
        }

        @Override
        public int getResultSetType() throws SQLException {
            return this.resultSetType;
        }

        @Override
        public void addBatch(String sql) throws SQLException {
            this.action(s -> {
                s.addBatch(sql);
                return null;
            });
        }

        @Override
        public void cancel() throws SQLException {
            this.action(s -> {
                s.cancel();
                return null;
            });
        }

        @Override
        public void clearBatch() throws SQLException {
            this.action(s -> {
                s.clearBatch();
                return null;
            });
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.action(s -> {
                s.clearWarnings();
                return null;
            });
        }

        @Override
        public void close() throws SQLException {
            this.delegate().close();
        }

        @Override
        public void closeOnCompletion() throws SQLException {
            this.action(s -> {
                s.closeOnCompletion();
                return null;
            });
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            return this.delegate().execute(sql);
        }

        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            return this.delegate().execute(sql, autoGeneratedKeys);
        }

        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            return this.delegate().execute(sql, columnIndexes);
        }

        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            return this.delegate().execute(sql, columnNames);
        }

        @Override
        public int[] executeBatch() throws SQLException {
            return this.delegate().executeBatch();
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            return this.delegate().executeQuery(sql);
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            return this.delegate().executeUpdate(sql);
        }

        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            return this.delegate().executeUpdate(sql, autoGeneratedKeys);
        }

        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            return this.delegate().executeUpdate(sql, columnIndexes);
        }

        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            return this.delegate().executeUpdate(sql, columnNames);
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.delegate().getConnection();
        }

        @Override
        public int getFetchDirection() throws SQLException {
            return this.delegate().getFetchDirection();
        }

        @Override
        public int getFetchSize() throws SQLException {
            return this.delegate().getFetchSize();
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate().getGeneratedKeys();
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            return this.delegate().getMaxFieldSize();
        }

        @Override
        public int getMaxRows() throws SQLException {
            return this.delegate().getMaxRows();
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            return this.delegate().getMoreResults();
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            return this.delegate().getMoreResults(current);
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            return this.delegate().getQueryTimeout();
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            return this.delegate().getResultSet();
        }

        @Override
        public int getUpdateCount() throws SQLException {
            return this.delegate().getUpdateCount();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.delegate().getWarnings();
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            return this.delegate().isCloseOnCompletion();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.delegate().isClosed();
        }

        @Override
        public boolean isPoolable() throws SQLException {
            return this.delegate().isPoolable();
        }

        @Override
        public void setCursorName(String name) throws SQLException {
            this.action(s -> {
                s.setCursorName(name);
                return null;
            });
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.action(s -> {
                s.setEscapeProcessing(enable);
                return null;
            });
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
            this.action(s -> {
                s.setFetchDirection(direction);
                return null;
            });
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
            this.action(s -> {
                s.setFetchSize(rows);
                return null;
            });
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
            this.action(s -> {
                s.setMaxFieldSize(max);
                return null;
            });
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
            this.action(s -> {
                s.setMaxRows(max);
                return null;
            });
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
            this.action(s -> {
                s.setPoolable(poolable);
                return null;
            });
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
            this.action(s -> {
                s.setQueryTimeout(seconds);
                return null;
            });
        }
    }

    protected static interface SQLOperation<T, R> {
        public R run(T var1) throws SQLException;
    }
}

