/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.db.aurora;

import java.sql.Connection;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.threadly.db.AbstractDelegatingConnection;
import org.threadly.db.aurora.AuroraClusterMonitor;
import org.threadly.db.aurora.AuroraServer;
import org.threadly.db.aurora.DelegateDriver;
import org.threadly.util.Clock;
import org.threadly.util.Pair;

public class DelegatingAuroraConnection
extends AbstractDelegatingConnection
implements Connection {
    public static final String URL_PREFIX = "jdbc:mysql:aurora://";
    private final ConnectionStateManager connectionStateManager;
    private final ConnectionStateManager.ConnectionHolder[] connections;
    private final AuroraServer[] servers;
    private final Connection referenceConnection;
    private final AuroraClusterMonitor clusterMonitor;
    private final AtomicBoolean closed;
    private volatile Pair<AuroraServer, ConnectionStateManager.ConnectionHolder> stickyConnection;

    public static boolean acceptsURL(String url) {
        return url != null && url.startsWith(URL_PREFIX);
    }

    public DelegatingAuroraConnection(String url, Properties info) throws SQLException {
        int endDelim = url.indexOf(47, URL_PREFIX.length());
        if (endDelim < 0) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        String urlArgs = url.substring(endDelim);
        String[] servers = url.substring(URL_PREFIX.length(), endDelim).split(",");
        if (servers.length == 0) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        this.connectionStateManager = urlArgs.contains("optimizedStateUpdates=true") ? new OptimizedConnectionStateManager() : new SafeConnectionStateManager();
        HashMap<AuroraServer, ConnectionStateManager.ConnectionHolder> connections = new HashMap<AuroraServer, ConnectionStateManager.ConnectionHolder>();
        ConnectionStateManager.ConnectionHolder firstConnectionHolder = null;
        Pair connectException = null;
        for (String s : servers) {
            AuroraServer auroraServer = new AuroraServer(s, info);
            if (connections.containsKey(auroraServer)) continue;
            try {
                connections.put(auroraServer, connectException != null ? null : this.connectionStateManager.wrapConnection(DelegateDriver.connect(s + urlArgs, info)));
            }
            catch (SQLException e) {
                connectException = new Pair((Object)auroraServer, (Object)e);
            }
            if (connectException != null || firstConnectionHolder != null) continue;
            firstConnectionHolder = (ConnectionStateManager.ConnectionHolder)connections.get(auroraServer);
        }
        this.clusterMonitor = AuroraClusterMonitor.getMonitor(connections.keySet());
        if (connectException != null) {
            this.clusterMonitor.expediteServerCheck((AuroraServer)connectException.getLeft());
            throw (SQLException)connectException.getRight();
        }
        this.connections = connections.values().toArray(new ConnectionStateManager.ConnectionHolder[connections.size()]);
        this.servers = connections.keySet().toArray(new AuroraServer[connections.size()]);
        this.referenceConnection = firstConnectionHolder.uncheckedState();
        this.closed = new AtomicBoolean();
        this.stickyConnection = null;
    }

    @Override
    protected void resetStickyConnection() {
        this.stickyConnection = null;
    }

    @Override
    protected Connection getReferenceConnection() {
        return this.referenceConnection;
    }

    public String toString() {
        return DelegatingAuroraConnection.class.getSimpleName() + ":" + Arrays.toString(this.servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws SQLException {
        if (!this.closed.compareAndSet(false, true)) return;
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                ch.uncheckedState().close();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
            if (!ch.uncheckedState().isClosed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connectionStateManager.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return this.connectionStateManager.isReadOnly();
    }

    @Override
    protected <R> R processOnDelegate(AbstractDelegatingConnection.SQLOperation<Connection, R> action) throws SQLException {
        Pair<AuroraServer, ConnectionStateManager.ConnectionHolder> p = this.getDelegate();
        try {
            return action.run(((ConnectionStateManager.ConnectionHolder)p.getRight()).verifiedState());
        }
        catch (SQLException e) {
            this.clusterMonitor.expediteServerCheck((AuroraServer)p.getLeft());
            throw e;
        }
    }

    protected Pair<AuroraServer, ConnectionStateManager.ConnectionHolder> getDelegate() throws SQLException {
        DelegatingAuroraConnection delegatingAuroraConnection = this;
        synchronized (delegatingAuroraConnection) {
            AuroraServer server;
            if (this.stickyConnection != null) {
                return this.stickyConnection;
            }
            if (this.connectionStateManager.isReadOnly()) {
                server = this.clusterMonitor.getRandomReadReplica();
                if (server == null) {
                    server = this.clusterMonitor.getCurrentMaster();
                }
            } else {
                server = this.clusterMonitor.getCurrentMaster();
                if (server == null) {
                    server = this.clusterMonitor.getRandomReadReplica();
                }
            }
            if (server == null) {
                throw new SQLException("No healthy servers");
            }
            for (int i = 0; i < this.servers.length; ++i) {
                if (!this.servers[i].equals(server)) continue;
                Pair result = new Pair((Object)server, (Object)this.connections[i]);
                if (!this.connectionStateManager.isAutoCommit()) {
                    this.stickyConnection = result;
                }
                return result;
            }
            throw new IllegalStateException("Cluster monitor provided unknown server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        DelegatingAuroraConnection delegatingAuroraConnection = this;
        synchronized (delegatingAuroraConnection) {
            this.connectionStateManager.setAutoCommit(autoCommit);
            if (autoCommit) {
                this.stickyConnection = null;
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connectionStateManager.isAutoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            if (this.referenceConnection.getCatalog() == null && catalog != null || !this.referenceConnection.getCatalog().equals(catalog)) {
                for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                    ch.uncheckedState().setCatalog(catalog);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connectionStateManager.setTransactionIsolationLevel(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connectionStateManager.getTransactionIsolationLevel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning result = null;
        for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
            SQLWarning conWarnings = ch.uncheckedState().getWarnings();
            if (conWarnings == null) continue;
            if (result == null) {
                result = conWarnings;
                continue;
            }
            result.setNextWarning(conWarnings);
        }
        return result;
    }

    @Override
    public void clearWarnings() throws SQLException {
        for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
            ch.uncheckedState().clearWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                ch.uncheckedState().setTypeMap(map);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldability(int holdability) throws SQLException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            if (this.referenceConnection.getHoldability() != holdability) {
                for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                    ch.uncheckedState().setHoldability(holdability);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        long startTime = timeout == 0 ? 0L : Clock.accurateForwardProgressingMillis();
        for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
            int remainingTimeout;
            if (timeout == 0) {
                remainingTimeout = 0;
            } else {
                remainingTimeout = timeout - (int)Math.floor((double)(Clock.lastKnownForwardProgressingMillis() - startTime) / 1000.0);
                if (remainingTimeout <= 0) {
                    return false;
                }
            }
            if (ch.uncheckedState().isValid(remainingTimeout)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                ch.uncheckedState().setClientInfo(name, value);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                ch.uncheckedState().setClientInfo(properties);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            if (this.referenceConnection.getSchema() == null && schema != null || !this.referenceConnection.getSchema().equals(schema)) {
                for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                    ch.uncheckedState().setSchema(schema);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Executor executor) throws SQLException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            this.closed.set(true);
            for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                ch.uncheckedState().abort(executor);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        ConnectionStateManager.ConnectionHolder[] connectionHolderArray = this.connections;
        synchronized (this.connections) {
            for (ConnectionStateManager.ConnectionHolder ch : this.connections) {
                ch.uncheckedState().setNetworkTimeout(executor, milliseconds);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected static class OptimizedConnectionStateManager
    extends ConnectionStateManager {
        protected OptimizedConnectionStateManager() {
        }

        @Override
        protected ConnectionStateManager.ConnectionHolder makeConnectionHolder(Connection connection) {
            return new OptimizedConnectionHolder(connection);
        }

        protected class OptimizedConnectionHolder
        extends ConnectionStateManager.ConnectionHolder {
            private boolean connectionReadOnly;
            private boolean connectionAutoCommit;
            private int connectionTransactionIsolationLevel;

            public OptimizedConnectionHolder(Connection connection) {
                super(connection);
                this.connectionReadOnly = OptimizedConnectionStateManager.this.readOnly;
                this.connectionAutoCommit = OptimizedConnectionStateManager.this.autoCommit;
                this.connectionTransactionIsolationLevel = OptimizedConnectionStateManager.this.transactionIsolationLevel;
            }

            @Override
            public Connection verifiedState() throws SQLException {
                if (this.connectionReadOnly != OptimizedConnectionStateManager.this.readOnly) {
                    this.connectionReadOnly = OptimizedConnectionStateManager.this.readOnly;
                    this.connection.setReadOnly(OptimizedConnectionStateManager.this.readOnly);
                }
                if (this.connectionAutoCommit != OptimizedConnectionStateManager.this.autoCommit) {
                    this.connectionAutoCommit = OptimizedConnectionStateManager.this.autoCommit;
                    this.connection.setAutoCommit(OptimizedConnectionStateManager.this.autoCommit);
                }
                if (this.connectionTransactionIsolationLevel != OptimizedConnectionStateManager.this.transactionIsolationLevel) {
                    this.connectionTransactionIsolationLevel = OptimizedConnectionStateManager.this.transactionIsolationLevel;
                    this.connection.setTransactionIsolation(OptimizedConnectionStateManager.this.transactionIsolationLevel);
                }
                return this.connection;
            }
        }
    }

    protected static class SafeConnectionStateManager
    extends ConnectionStateManager {
        private volatile int readOnlyModificationCount = 0;
        private volatile int autoCommitModificationCount = 0;
        private volatile int transactionIsolationLevelModificationCount = 0;

        protected SafeConnectionStateManager() {
        }

        @Override
        public void setReadOnly(boolean readOnly) {
            super.setReadOnly(readOnly);
            ++this.readOnlyModificationCount;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
            super.setAutoCommit(autoCommit);
            ++this.autoCommitModificationCount;
        }

        @Override
        public void setTransactionIsolationLevel(int level) {
            super.setTransactionIsolationLevel(level);
            ++this.transactionIsolationLevelModificationCount;
        }

        @Override
        protected ConnectionStateManager.ConnectionHolder makeConnectionHolder(Connection connection) {
            return new SafeConnectionHolder(connection);
        }

        protected class SafeConnectionHolder
        extends ConnectionStateManager.ConnectionHolder {
            private int connectionReadOnlyModificationCount;
            private int connectionAutoCommitModificationCount;
            private int connectionIsolationLevelModificationCount;

            public SafeConnectionHolder(Connection connection) {
                super(connection);
                this.connectionReadOnlyModificationCount = SafeConnectionStateManager.this.readOnlyModificationCount;
                this.connectionAutoCommitModificationCount = SafeConnectionStateManager.this.autoCommitModificationCount;
                this.connectionIsolationLevelModificationCount = SafeConnectionStateManager.this.transactionIsolationLevelModificationCount;
            }

            @Override
            public Connection verifiedState() throws SQLException {
                if (this.connectionReadOnlyModificationCount != SafeConnectionStateManager.this.readOnlyModificationCount) {
                    this.connectionReadOnlyModificationCount = SafeConnectionStateManager.this.readOnlyModificationCount;
                    this.connection.setReadOnly(SafeConnectionStateManager.this.readOnly);
                }
                if (this.connectionAutoCommitModificationCount != SafeConnectionStateManager.this.autoCommitModificationCount) {
                    this.connectionAutoCommitModificationCount = SafeConnectionStateManager.this.autoCommitModificationCount;
                    this.connection.setAutoCommit(SafeConnectionStateManager.this.autoCommit);
                }
                if (this.connectionIsolationLevelModificationCount != SafeConnectionStateManager.this.transactionIsolationLevelModificationCount) {
                    this.connectionIsolationLevelModificationCount = SafeConnectionStateManager.this.transactionIsolationLevelModificationCount;
                    this.connection.setTransactionIsolation(SafeConnectionStateManager.this.transactionIsolationLevel);
                }
                return this.connection;
            }
        }
    }

    protected static abstract class ConnectionStateManager {
        protected volatile boolean readOnly;
        protected volatile boolean autoCommit;
        protected volatile int transactionIsolationLevel = Integer.MIN_VALUE;

        protected ConnectionStateManager() {
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setAutoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        public boolean isAutoCommit() {
            return this.autoCommit;
        }

        public void setTransactionIsolationLevel(int level) {
            this.transactionIsolationLevel = level;
        }

        public int getTransactionIsolationLevel() {
            return this.transactionIsolationLevel;
        }

        public ConnectionHolder wrapConnection(Connection connection) throws SQLException {
            if (this.transactionIsolationLevel == Integer.MIN_VALUE) {
                this.readOnly = connection.isReadOnly();
                this.autoCommit = connection.getAutoCommit();
                this.transactionIsolationLevel = connection.getTransactionIsolation();
            }
            return this.makeConnectionHolder(connection);
        }

        protected abstract ConnectionHolder makeConnectionHolder(Connection var1);

        public static abstract class ConnectionHolder {
            protected final Connection connection;

            public ConnectionHolder(Connection connection) {
                this.connection = connection;
            }

            public Connection uncheckedState() {
                return this.connection;
            }

            public abstract Connection verifiedState() throws SQLException;
        }
    }
}

