/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.db.aurora;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.threadly.db.aurora.AuroraDataSourceFactory;
import org.threadly.db.aurora.NonRegisteringDriver;
import org.threadly.util.StringUtils;

public final class AuroraDataSource
implements DataSource,
Referenceable,
Serializable {
    private static final long serialVersionUID = -8925224249843386407L;
    private static final NonRegisteringDriver DRIVER = new NonRegisteringDriver();
    private static final int DEFAULT_PORT = 3306;
    protected transient PrintWriter logWriter = null;
    protected String databaseName = null;
    protected String hostName = null;
    protected int port = 3306;
    protected String user = null;
    protected String password = null;
    protected boolean explicitUrl = false;
    protected String url = null;

    private static String nullSafeRefAddrStringGet(String referenceName, Reference ref) {
        RefAddr refAddr = ref.get(referenceName);
        return refAddr != null ? (String)refAddr.getContent() : null;
    }

    public AuroraDataSource() {
    }

    protected AuroraDataSource(Reference ref) {
        this();
        String explicitUrlAsString;
        String databaseName;
        String serverName;
        String password;
        String user;
        String portNumberStr = AuroraDataSource.nullSafeRefAddrStringGet("port", ref);
        if (!StringUtils.isNullOrEmpty((String)portNumberStr)) {
            int portNumber = Integer.parseInt(portNumberStr);
            this.setPort(portNumber);
        }
        if ((user = AuroraDataSource.nullSafeRefAddrStringGet("user", ref)) != null) {
            this.setUsername(user);
        }
        if ((password = AuroraDataSource.nullSafeRefAddrStringGet("password", ref)) != null) {
            this.setPassword(password);
        }
        if ((serverName = AuroraDataSource.nullSafeRefAddrStringGet("serverName", ref)) != null) {
            this.setServerName(serverName);
        }
        if ((databaseName = AuroraDataSource.nullSafeRefAddrStringGet("databaseName", ref)) != null) {
            this.setDatabaseName(databaseName);
        }
        if (!StringUtils.isNullOrEmpty((String)(explicitUrlAsString = AuroraDataSource.nullSafeRefAddrStringGet("explicitUrl", ref))) && Boolean.parseBoolean(explicitUrlAsString)) {
            this.setURL(AuroraDataSource.nullSafeRefAddrStringGet("url", ref));
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        String factoryName = AuroraDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr("user", this.user));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("port", Integer.toString(this.port)));
        ref.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        ref.add(new StringRefAddr("explicitUrl", Boolean.toString(this.explicitUrl)));
        ref.add(new StringRefAddr("url", StringUtils.nullToEmpty((String)this.url)));
        return ref;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String userID, String pass) throws SQLException {
        Properties props = new Properties();
        if (userID != null) {
            props.setProperty("user", userID);
        }
        if (pass != null) {
            props.setProperty("password", pass);
        }
        return DRIVER.connect(this.getURL(), props);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLogWriter(PrintWriter output) throws SQLException {
        this.logWriter = output;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.user = username;
    }

    public String getUsername() {
        return this.user;
    }

    public void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public String getDatabaseName() {
        return StringUtils.nullToEmpty((String)this.databaseName);
    }

    public void setServerName(String serverName) {
        this.hostName = serverName;
    }

    public String getServerName() {
        return StringUtils.nullToEmpty((String)this.hostName);
    }

    public void setURL(String url) {
        this.url = url;
        this.explicitUrl = true;
    }

    public String getURL() {
        if (this.explicitUrl) {
            return this.url;
        }
        StringBuilder urlSb = new StringBuilder();
        urlSb.append("jdbc:mysql:aurora://").append(this.getServerName()).append(":").append(this.port).append("/").append(this.getDatabaseName());
        return urlSb.toString();
    }
}

