/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.litesockets.protocols.sdp;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threadly.litesockets.protocols.sdp.SDPProtocol;

public class SDP {
    private final SDPProtocol.SDPVersion version;
    private final SDPProtocol.SDPOrigin origin;
    private final SDPProtocol.SDPSession session;
    private final SDPProtocol.SDPTime time;
    private final SDPProtocol.SDPConnection connection;
    private final List<SDPProtocol.SDPAttribute> sessionAttributes;
    private final Set<SDPProtocol.SDPMedia> media;
    private final Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPAttribute>> mediaAttributes;
    private final Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPConnection>> mediaConnection;
    private final String sdpString;

    SDP(SDPProtocol.SDPVersion version, SDPProtocol.SDPOrigin origin, SDPProtocol.SDPSession session, SDPProtocol.SDPTime time, SDPProtocol.SDPConnection connection, List<SDPProtocol.SDPAttribute> sessionAttributes, Set<SDPProtocol.SDPMedia> media, Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPAttribute>> mediaAttributes, Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPConnection>> mediaConnection) {
        this.version = version;
        this.origin = origin;
        this.session = session;
        this.time = time;
        this.connection = connection;
        this.sessionAttributes = Collections.unmodifiableList(sessionAttributes);
        this.media = Collections.unmodifiableSet(media);
        this.mediaAttributes = Collections.unmodifiableMap(mediaAttributes);
        this.mediaConnection = Collections.unmodifiableMap(mediaConnection);
        this.sdpString = SDPProtocol.SDPToString(version, origin, session, time, connection, sessionAttributes, media, mediaAttributes, mediaConnection);
    }

    public SDPProtocol.SDPVersion getVersion() {
        return this.version;
    }

    public SDPProtocol.SDPOrigin getOrigin() {
        return this.origin;
    }

    public SDPProtocol.SDPSession getSession() {
        return this.session;
    }

    public SDPProtocol.SDPTime getTime() {
        return this.time;
    }

    public SDPProtocol.SDPConnection getConnection() {
        return this.connection;
    }

    public List<SDPProtocol.SDPAttribute> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public Set<SDPProtocol.SDPMedia> getMedia() {
        return this.media;
    }

    public Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPAttribute>> getMediaAttributes() {
        return this.mediaAttributes;
    }

    public Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPConnection>> getMediaConnection() {
        return this.mediaConnection;
    }

    public String getSdpString() {
        return this.sdpString;
    }

    public ByteBuffer getBytes() {
        return ByteBuffer.wrap(this.sdpString.getBytes());
    }

    public String toString() {
        return this.sdpString;
    }

    public int hashCode() {
        return this.sdpString.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof SDP && o.hashCode() == this.hashCode() && o.toString().equals(this.toString());
    }
}

