/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.litesockets.protocols.sdp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threadly.litesockets.protocols.sdp.SDP;
import org.threadly.litesockets.protocols.sdp.SDPConstants;
import org.threadly.litesockets.protocols.sdp.SDPProtocol;

public class SDPBuilder {
    private SDPProtocol.SDPVersion version = SDPConstants.SDP_VERSION;
    private SDPProtocol.SDPOrigin origin = null;
    private SDPProtocol.SDPSession session = null;
    private SDPProtocol.SDPTime time = null;
    private SDPProtocol.SDPConnection connection = null;
    private List<SDPProtocol.SDPAttribute> sessionAttributes = new ArrayList<SDPProtocol.SDPAttribute>();
    private Set<SDPProtocol.SDPMedia> media = new LinkedHashSet<SDPProtocol.SDPMedia>();
    private Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPAttribute>> mediaAttributes = new HashMap<SDPProtocol.SDPMedia, List<SDPProtocol.SDPAttribute>>();
    private Map<SDPProtocol.SDPMedia, List<SDPProtocol.SDPConnection>> mediaConnection = new HashMap<SDPProtocol.SDPMedia, List<SDPProtocol.SDPConnection>>();

    public SDPBuilder setVersion(SDPProtocol.SDPVersion ver) {
        this.version = ver;
        return this;
    }

    public SDPBuilder setOrigin(SDPProtocol.SDPOrigin origin) {
        this.origin = origin;
        return this;
    }

    public SDPBuilder setSession(SDPProtocol.SDPSession session) {
        this.session = session;
        return this;
    }

    public SDPBuilder setTime(SDPProtocol.SDPTime time) {
        this.time = time;
        return this;
    }

    public SDPBuilder setSessionConnection(SDPProtocol.SDPConnection connection) {
        this.connection = connection;
        return this;
    }

    public SDPBuilder addSessionAttribute(SDPProtocol.SDPAttribute attribute) {
        if (!this.sessionAttributes.contains(attribute)) {
            this.sessionAttributes.add(attribute);
        }
        return this;
    }

    public SDPBuilder removeSessionAttribute(SDPProtocol.SDPAttribute attribute) {
        while (this.sessionAttributes.remove(attribute)) {
        }
        return this;
    }

    public SDPBuilder addMedia(SDPProtocol.SDPMedia media) {
        this.media.add(media);
        if (!this.mediaAttributes.containsKey(media)) {
            this.mediaAttributes.put(media, new ArrayList());
        }
        if (!this.mediaConnection.containsKey(media)) {
            this.mediaConnection.put(media, new ArrayList());
        }
        return this;
    }

    public SDPBuilder removeMedia(SDPProtocol.SDPMedia media) {
        this.media.remove(media);
        this.mediaAttributes.remove(media);
        this.mediaConnection.remove(media);
        return this;
    }

    public SDPBuilder addMediaAttribute(SDPProtocol.SDPMedia media, SDPProtocol.SDPAttribute attribute) {
        if (this.media.contains(media)) {
            List<SDPProtocol.SDPAttribute> ma = this.mediaAttributes.get(media);
            if (!ma.contains(attribute)) {
                ma.add(attribute);
            }
            return this;
        }
        throw new IllegalArgumentException("Media:" + media + ", does not exist yet!");
    }

    public SDPBuilder removeMediaAttribute(SDPProtocol.SDPMedia media, SDPProtocol.SDPAttribute attribute) {
        if (this.media.contains(media)) {
            this.mediaAttributes.get(media).remove(attribute);
            return this;
        }
        throw new IllegalArgumentException("Media:" + media + ", does not exist yet!");
    }

    public SDPBuilder addMediaConnection(SDPProtocol.SDPMedia media, SDPProtocol.SDPConnection connection) {
        if (this.media.contains(media)) {
            List<SDPProtocol.SDPConnection> mc = this.mediaConnection.get(media);
            if (!mc.contains(connection)) {
                mc.add(connection);
            }
            return this;
        }
        throw new IllegalArgumentException("Media:" + media + ", does not exist yet!");
    }

    public SDPBuilder removeMediaConnection(SDPProtocol.SDPMedia media, SDPProtocol.SDPConnection connection) {
        if (this.media.contains(media)) {
            this.mediaConnection.get(media).remove(connection);
            return this;
        }
        throw new IllegalArgumentException("Media:" + media + ", does not exist yet!");
    }

    public SDPBuilder clone() {
        SDPBuilder clone = new SDPBuilder();
        clone.setVersion(this.version);
        clone.setOrigin(this.origin);
        clone.setSession(this.session);
        clone.setTime(this.time);
        clone.setSessionConnection(this.connection);
        for (SDPProtocol.SDPMedia m : this.media) {
            clone.addMedia(m);
            List<SDPProtocol.SDPConnection> mc = this.mediaConnection.get(m);
            List<SDPProtocol.SDPAttribute> ma = this.mediaAttributes.get(m);
            for (SDPProtocol.SDPConnection c : mc) {
                clone.addMediaConnection(m, c);
            }
            for (SDPProtocol.SDPAttribute a : ma) {
                clone.addMediaAttribute(m, a);
            }
        }
        return clone;
    }

    public SDP build() {
        return new SDP(this.version, this.origin, this.session, this.time, this.connection, new ArrayList<SDPProtocol.SDPAttribute>(this.sessionAttributes), new LinkedHashSet<SDPProtocol.SDPMedia>(this.media), new HashMap<SDPProtocol.SDPMedia, List<SDPProtocol.SDPAttribute>>(this.mediaAttributes), new HashMap<SDPProtocol.SDPMedia, List<SDPProtocol.SDPConnection>>(this.mediaConnection));
    }

    public static void main(String[] args) {
        System.out.println(new SDPBuilder().clone().build());
    }
}

