package org.thryft.waf.cli;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Preconditions.checkState;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import com.beust.jcommander.Parameters;
import com.google.common.base.CaseFormat;
import com.google.inject.Injector;

public abstract class Command<ArgsT extends Command.Args> {
    @Parameters(separators = " ")
    public static class Args {
    }

    protected Command(final ArgsT args) {
        this.args = checkNotNull(args);
        logger = LoggerFactory.getLogger(getClass());
        final String classSimpleName = getClass().getSimpleName();
        checkState(classSimpleName.endsWith("Command"));
        final String classSimpleNamePrefix = classSimpleName.substring(0,
                classSimpleName.length() - "Command".length());
        logMarker = MarkerFactory
                .getMarker(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, classSimpleNamePrefix));
        name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, classSimpleNamePrefix).replace('_', '-');
    }

    public final ArgsT getArgs() {
        return args;
    }

    public final String getName() {
        return name;
    }

    public abstract void run(final Injector injector);

    private final ArgsT args;
    protected final Logger logger;
    protected final Marker logMarker;
    private final String name;
}
