/*
 * Decompiled with CFR 0.152.
 */
package org.thryft.waf.cli;

import com.beust.jcommander.Parameters;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class Command<ArgsT extends Args> {
    private final ArgsT args;
    protected final Logger logger;
    protected final Marker logMarker;
    private final String name;

    protected Command(ArgsT args) {
        this.args = (Args)Preconditions.checkNotNull(args);
        this.logger = LoggerFactory.getLogger(this.getClass());
        String classSimpleName = this.getClass().getSimpleName();
        Preconditions.checkState((boolean)classSimpleName.endsWith("Command"));
        String classSimpleNamePrefix = classSimpleName.substring(0, classSimpleName.length() - "Command".length());
        this.logMarker = MarkerFactory.getMarker((String)CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, classSimpleNamePrefix));
        this.name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, classSimpleNamePrefix).replace('_', '-');
    }

    public final ArgsT getArgs() {
        return this.args;
    }

    public final String getName() {
        return this.name;
    }

    public abstract void run(Injector var1);

    @Parameters(separators=" ")
    public static class Args {
    }
}

