/*
 * Decompiled with CFR 0.152.
 */
package org.thryft.waf.cli;

import com.beust.jcommander.JCommander;
import com.google.common.base.Preconditions;
import org.thryft.waf.cli.Command;

public final class CommandParser
extends JCommander {
    private final Command<?>[] commands;

    public CommandParser(Object args, Command<?>[] commands) {
        super(args);
        this.commands = (Command[])Preconditions.checkNotNull(commands);
        for (Command<?> command : commands) {
            this.addCommand(command.getName(), command.getArgs());
        }
    }

    public Command<?> getCommand() {
        for (Command<?> command : this.commands) {
            if (!this.getParsedCommand().equals(command.getName())) continue;
            return command;
        }
        throw new IllegalStateException();
    }

    public void parse(String ... args) {
        super.parse(args);
        if (this.getParsedCommand() == null) {
            this.usage();
            System.exit(1);
        }
    }
}

