package org.thryft.waf.cli;

import static com.google.common.base.Preconditions.checkNotNull;

import com.beust.jcommander.JCommander;

public final class CommandParser extends JCommander {
    public CommandParser(final Object args, final Command<?>[] commands) {
        super(args);
        this.commands = checkNotNull(commands);
        for (final Command<?> command : commands) {
            addCommand(command.getName(), command.getArgs());
        }
    }

    public Command<?> getCommand() {
        for (final Command<?> command : commands) {
            if (getParsedCommand().equals(command.getName())) {
                return command;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void parse(final String... args) {
        super.parse(args);
        if (getParsedCommand() == null) {
            usage();
            System.exit(1);
        }
    }

    private final Command<?>[] commands;
}
