/*
 * Decompiled with CFR 0.152.
 */
package org.thryft.waf.cli;

import ch.qos.logback.core.joran.spi.JoranException;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.base.Preconditions;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.thryft.waf.lib.logging.LoggingConfigurator;

public abstract class CliMain {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Marker logMarker;

    protected CliMain(Marker logMarker) {
        this.logMarker = (Marker)Preconditions.checkNotNull((Object)logMarker);
    }

    protected final void _configureLogging(Args args, String projectName) throws JoranException {
        if (args.logbackXmlFileName != null) {
            LoggingConfigurator.configureLoggingFromFileName((String)args.logbackXmlFileName, this.getClass(), (String)projectName);
        } else if (args.logbackXmlFilePath != null) {
            LoggingConfigurator.configureLoggingFromFilePath((File)args.logbackXmlFilePath);
        } else {
            throw new IllegalArgumentException("must specify --logback-xml-file-name or --logback-xml-file-path");
        }
    }

    protected final Logger _getLogger() {
        return this.logger;
    }

    protected final Marker _getLogMarker() {
        return this.logMarker;
    }

    public static final class FileParameterConverter
    implements IStringConverter<File> {
        public File convert(String value) {
            File file = new File(value);
            if (!file.isFile()) {
                throw new ParameterException(String.format("'%s' is not a valid file path", value));
            }
            return file;
        }
    }

    public static class Args {
        @Parameter(names={"-h", "--help"}, help=true)
        private boolean help;
        @Parameter(names={"-ln", "--logback-xml-file-name"}, description="name of logback.xml in /etc/notablist or ~/.notablist")
        public String logbackXmlFileName = null;
        @Parameter(names={"-lp", "--logback-xml-file-path"}, converter=FileParameterConverter.class, description="path to logback.xml")
        public File logbackXmlFilePath = null;
    }
}

