package org.thryft.waf.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

import javax.servlet.ServletContextEvent;

import org.thryft.waf.lib.logging.LoggingConfigurator;

import com.google.inject.servlet.GuiceServletContextListener;

public abstract class AbstractServletContextListener extends GuiceServletContextListener {
    protected final void _configureLogging(final String projectName) {
        LoggingConfigurator.configureLoggingFromFileName("middleware-logback.xml", getClass(), projectName);
    }

    protected final void _createVaadinScssCache(final String projectName,
            final ServletContextEvent servletContextEvent) {
        final String root = servletContextEvent.getServletContext().getRealPath("/");
        if (root != null && Files.isDirectory(Paths.get(root))) {
            // workaround for https://dev.vaadin.com/ticket/18463
            try {
                Files.createDirectories(Paths
                        .get(servletContextEvent.getServletContext().getRealPath("/VAADIN/themes/" + projectName)));
            } catch (final IOException e) {
            }
        }
    }
}
