package org.thryft.waf.server.controllers;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.inject.Singleton;

@Singleton
public class ExceptionLoggingFilter implements Filter {
    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain)
            throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        } catch (final IOException | RuntimeException | ServletException e) {
            logger.error("Uncaught exception: ", e);
            throw e;
        }
    }

    @Override
    public void init(final FilterConfig filterConfig) throws ServletException {
    }

    private final static Logger logger = LoggerFactory.getLogger(ExceptionLoggingFilter.class);
}
