package org.thryft.waf.server.controllers.oauth;

import static com.google.common.base.Preconditions.checkNotNull;

import org.thryft.native_.EmailAddress;

public final class OauthUserProfile {
    public final static class Builder {
        private Builder() {
        }

        public OauthUserProfile build() {
            return new OauthUserProfile(emailAddress, username);
        }

        public EmailAddress getEmailAddress() {
            return emailAddress;
        }

        public String getUsername() {
            return username;
        }

        public Builder setEmailAddress(final EmailAddress emailAddress) {
            this.emailAddress = checkNotNull(emailAddress);
            return this;
        }

        public Builder setUsername(final String username) {
            this.username = checkNotNull(username);
            return this;
        }

        private EmailAddress emailAddress = null;
        private String username = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OauthUserProfile(final EmailAddress emailAddress, final String username) {
        this.emailAddress = checkNotNull(emailAddress);
        this.username = checkNotNull(username);
    }

    public final EmailAddress getEmailAddress() {
        return emailAddress;
    }

    public final String getUsername() {
        return username;
    }

    private final EmailAddress emailAddress;
    private final String username;
}
