/*
 * Decompiled with CFR 0.152.
 */
package org.thryft.waf.server.controllers;

import com.google.inject.Singleton;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.thryft.waf.lib.logging.LoggingUtils;

@Singleton
public class LocalhostFilter
implements Filter {
    private final Set<String> localAddresses = new HashSet<String>();
    private final Logger logger = LoggerFactory.getLogger(LocalhostFilter.class);
    private final Marker logMarker = LoggingUtils.getMarker(LocalhostFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.localAddresses.contains(request.getRemoteAddr())) {
            chain.doFilter(request, response);
        } else {
            this.logger.warn(this.logMarker, "denying request for {} from {}", (Object)((HttpServletRequest)request).getRequestURI(), (Object)request.getRemoteAddr());
            ((HttpServletResponse)response).sendError(403, String.format("only localhost (%s) access allowed, not remote address %s", StringUtils.join(this.localAddresses, (char)','), request.getRemoteAddr()));
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.localAddresses.add(InetAddress.getLocalHost().getHostAddress());
            for (InetAddress inetAddress : InetAddress.getAllByName("localhost")) {
                this.localAddresses.add(inetAddress.getHostAddress());
            }
        }
        catch (IOException e) {
            throw new ServletException("Unable to lookup local addresses");
        }
    }
}

