/*
 * Decompiled with CFR 0.152.
 */
package org.thryft.waf.server.controllers;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExceptionLoggingFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionLoggingFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (IOException | RuntimeException | ServletException e) {
            logger.error("Uncaught exception: ", e);
            throw e;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

