/*
 * Decompiled with CFR 0.152.
 */
package org.thryft.waf.server.controllers.oauth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.DisabledAccountException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.thryft.native_.GenericUri;
import org.thryft.native_.Uri;
import org.thryft.native_.Url;
import org.thryft.waf.api.models.ModelEntry;
import org.thryft.waf.api.services.IoException;
import org.thryft.waf.lib.logging.LoggingUtils;
import org.thryft.waf.server.controllers.oauth.Oauth2ServiceProvider;
import org.thryft.waf.server.controllers.oauth.OauthUserProfile;

public abstract class AbstractOauthLoginController<IoExceptionT extends IoException, UserEntryT extends ModelEntry<?, ?>>
extends HttpServlet {
    private final ImmutableMap<String, Oauth2ServiceProvider> oauthServiceProviders;
    private static final Logger logger = LoggerFactory.getLogger(AbstractOauthLoginController.class);
    static final Marker LOG_MARKER = LoggingUtils.getMarker(AbstractOauthLoginController.class);

    protected AbstractOauthLoginController(ImmutableMap<String, Oauth2ServiceProvider> oauthServiceProviders) {
        this.oauthServiceProviders = (ImmutableMap)Preconditions.checkNotNull(oauthServiceProviders);
    }

    protected abstract String _getFailedLoginUrl(String var1, String var2);

    protected abstract String _getNewLoginUrl(String var1);

    protected abstract String _getOauthCallbackUrlPathPrefix();

    protected Optional<String> _getOauthCallbackUrlScheme() {
        return Optional.absent();
    }

    protected abstract String _getSuccessfulLoginUrl(String var1);

    protected abstract Optional<UserEntryT> _getUser(String var1, OauthUserProfile var2) throws IoExceptionT;

    protected abstract void _login(UserEntryT var1);

    protected abstract UserEntryT _postUser(String var1, OauthUserProfile var2) throws IOException;

    protected final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Optional<UserEntryT> existingUserEntry;
        Url authorizationUrl;
        OauthUserProfile userProfile;
        if (httpServletRequest.getPathInfo() == null || httpServletRequest.getPathInfo().length() <= 1) {
            logger.debug(LOG_MARKER, "ignoring request with invalid path '{}'", (Object)(httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : ""));
            httpServletResponse.sendError(404);
            return;
        }
        String providerId = StringUtils.stripStart((String)httpServletRequest.getPathInfo(), (String)"/").toLowerCase();
        String hostHeader = httpServletRequest.getHeader("Host");
        if (hostHeader == null) {
            logger.debug(LOG_MARKER, "ignoring request with no Host header");
            httpServletResponse.sendError(400);
            return;
        }
        String stateParameterUrlDecoded = httpServletRequest.getParameter("state");
        Oauth2ServiceProvider serviceConfiguration = (Oauth2ServiceProvider)this.oauthServiceProviders.get((Object)providerId);
        if (serviceConfiguration == null) {
            logger.warn(LOG_MARKER, "unsupported OAuth provider '{}'", (Object)providerId);
            httpServletResponse.sendError(404);
            return;
        }
        Url httpServletRequestUrl = Url.parse((String)httpServletRequest.getRequestURL().toString());
        String callbackUrl = Url.parse((String)((String)this._getOauthCallbackUrlScheme().or((Object)httpServletRequestUrl.getScheme()) + "://" + hostHeader + this._getOauthCallbackUrlPathPrefix() + providerId)).toString();
        logger.debug(LOG_MARKER, "HTTP request URL: {}, OAuth callback URL: {}", (Object)httpServletRequestUrl, (Object)callbackUrl);
        ServiceBuilder serviceBuilder = new ServiceBuilder().apiKey(serviceConfiguration.getApiKey()).apiSecret(serviceConfiguration.getApiSecret()).callback(callbackUrl);
        if (serviceConfiguration.getScope().isPresent()) {
            serviceBuilder.scope((String)serviceConfiguration.getScope().get());
        }
        OAuth20Service service = (OAuth20Service)serviceBuilder.build((BaseApi)serviceConfiguration);
        String code = httpServletRequest.getParameter("code");
        String error = httpServletRequest.getParameter("error");
        if (code != null) {
            OAuth2AccessToken accessToken;
            try {
                accessToken = (OAuth2AccessToken)Preconditions.checkNotNull((Object)service.getAccessToken(code));
            }
            catch (OAuthException e) {
                logger.error(LOG_MARKER, "error getting OAuth access token: ", (Throwable)e);
                httpServletResponse.sendError(400);
                return;
            }
            logger.debug(LOG_MARKER, "getting user information from OAuth2 service provider '{}'", (Object)providerId);
            try {
                userProfile = serviceConfiguration.getUserProfile(service, accessToken);
            }
            catch (IOException e) {
                logger.warn(LOG_MARKER, "error getting OAuth user profile: ", (Throwable)e);
                httpServletResponse.sendError(500);
                return;
            }
        }
        if (error != null) {
            if (httpServletRequest.getContentLength() > 0) {
                try (BufferedReader requestReader2 = httpServletRequest.getReader();){
                    StringBuilder requestBodyStringBuilder = new StringBuilder();
                    char[] requestBodyBuffer = new char[128];
                    int requestBodyBytesRead = -1;
                    while ((requestBodyBytesRead = requestReader2.read(requestBodyBuffer)) > 0) {
                        requestBodyStringBuilder.append(requestBodyBuffer, 0, requestBodyBytesRead);
                    }
                    error = error + ":\n" + requestBodyStringBuilder.toString();
                }
                catch (IOException requestReader2) {
                    // empty catch block
                }
            }
            logger.error(LOG_MARKER, "OAuth2 error: ", (Object)error);
            String failedLoginUrl = this._getFailedLoginUrl(error, stateParameterUrlDecoded);
            logger.debug(LOG_MARKER, "redirecting user to {} after failed login", (Object)failedLoginUrl);
            httpServletResponse.sendRedirect(failedLoginUrl);
            return;
        }
        String authorizationUrlString = service.getAuthorizationUrl(null);
        try {
            authorizationUrl = Url.parse((String)authorizationUrlString);
        }
        catch (IllegalArgumentException e) {
            logger.error(LOG_MARKER, "error parsing authorization URL '{}': ", (Object)authorizationUrlString, (Object)e);
            throw new IllegalStateException();
        }
        logger.debug(LOG_MARKER, "redirecting user to authorization URL");
        if (stateParameterUrlDecoded == null || stateParameterUrlDecoded.isEmpty()) {
            stateParameterUrlDecoded = httpServletRequest.getHeader("Referer");
        }
        if (stateParameterUrlDecoded != null && !stateParameterUrlDecoded.isEmpty()) {
            String stateParameterUrlEncoded;
            try {
                stateParameterUrlEncoded = URLEncoder.encode(stateParameterUrlDecoded, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            authorizationUrl = authorizationUrl.getQuery().isPresent() ? (Url)GenericUri.builder((Uri)authorizationUrl).setQuery((String)authorizationUrl.getQuery().get() + "&state=" + stateParameterUrlEncoded).build() : (Url)GenericUri.builder((Uri)authorizationUrl).setQuery("?state=" + stateParameterUrlEncoded).build();
        }
        httpServletResponse.sendRedirect(authorizationUrl.toString());
        return;
        Optional newUserEntry = Optional.absent();
        try {
            existingUserEntry = this._getUser(providerId, userProfile);
            if (existingUserEntry.isPresent()) {
                logger.debug(LOG_MARKER, "logging in existing user {}", (Object)((ModelEntry)existingUserEntry.get()).getModel());
            } else {
                newUserEntry = Optional.of(this._postUser(providerId, userProfile));
                logger.debug(LOG_MARKER, "logging in new user {}", (Object)((ModelEntry)newUserEntry.get()).getModel());
            }
        }
        catch (IoException e) {
            logger.error(LOG_MARKER, "I/O exception logging in user {}: ", (Object)userProfile, (Object)e);
            httpServletResponse.sendError(500, ExceptionUtils.getRootCauseMessage((Throwable)e));
            return;
        }
        ModelEntry userEntry = (ModelEntry)existingUserEntry.or(newUserEntry).get();
        try {
            this._login(userEntry);
        }
        catch (DisabledAccountException e) {
            String failedLoginUrl = this._getFailedLoginUrl("inactive", stateParameterUrlDecoded);
            logger.warn(LOG_MARKER, "redirecting inactive user to {} ", (Object)failedLoginUrl);
            httpServletResponse.sendRedirect(failedLoginUrl);
            return;
        }
        catch (AuthenticationException e) {
            logger.error(LOG_MARKER, "error logging in {}: ", (Object)userEntry.getModel(), (Object)e);
            httpServletResponse.sendError(500, ExceptionUtils.getRootCauseMessage((Throwable)e));
            return;
        }
        String successfulLoginUrl = existingUserEntry.isPresent() ? this._getSuccessfulLoginUrl(stateParameterUrlDecoded) : this._getNewLoginUrl(stateParameterUrlDecoded);
        logger.debug(LOG_MARKER, "redirecting {} to {} after successful login", (Object)userEntry.getModel(), (Object)successfulLoginUrl);
        httpServletResponse.sendRedirect(successfulLoginUrl);
    }
}

