/*
 * Decompiled with CFR 0.152.
 */
package org.thryft.waf.server.controllers.oauth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.apis.FacebookApi;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.thryft.waf.lib.logging.LoggingUtils;
import org.thryft.waf.server.controllers.oauth.Oauth2ServiceProvider;
import org.thryft.waf.server.controllers.oauth.OauthUserProfile;

public final class FacebookOauth2ServiceProvider
extends FacebookApi
implements Oauth2ServiceProvider {
    private final String apiKey;
    private final String apiSecret;
    private final ObjectMapper objectMapper = new ObjectMapper();
    public static final String ID = "facebook";
    private static final Logger logger = LoggerFactory.getLogger(FacebookOauth2ServiceProvider.class);
    private static final Marker logMarker = LoggingUtils.getMarker(FacebookOauth2ServiceProvider.class);
    private static final Optional<String> SCOPE = Optional.of((Object)"email");

    public FacebookOauth2ServiceProvider(String apiKey, String apiSecret) {
        this.apiKey = (String)Preconditions.checkNotNull((Object)apiKey);
        this.apiSecret = (String)Preconditions.checkNotNull((Object)apiSecret);
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getApiSecret() {
        return this.apiSecret;
    }

    @Override
    public Optional<String> getScope() {
        return SCOPE;
    }

    @Override
    public OauthUserProfile getUserProfile(OAuth20Service service, OAuth2AccessToken accessToken) throws IOException {
        OAuthRequest request = new OAuthRequest(Verb.GET, "https://graph.facebook.com/me", (OAuthService)service);
        service.signRequest(accessToken, (AbstractRequest)request);
        Response response = request.send();
        if (response.getCode() != 200) {
            throw new IOException("non-200 response code: " + response.getCode());
        }
        Map me = (Map)this.objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        OauthUserProfile.Builder resultBuilder = OauthUserProfile.builder();
        for (Map.Entry entry : me.entrySet()) {
            if (((String)entry.getKey()).equals("id")) {
                String id = entry.getValue().toString();
                Preconditions.checkState((!id.isEmpty() ? 1 : 0) != 0);
                resultBuilder.setUsername(id);
                continue;
            }
            if (((String)entry.getKey()).equals("email")) {
                resultBuilder.setEmailAddress((String)entry.getValue());
                continue;
            }
            logger.debug(logMarker, "unknown me field {}: {}", entry.getKey(), entry.getValue());
        }
        try {
            return resultBuilder.build();
        }
        catch (NullPointerException e) {
            throw new IOException(e);
        }
    }
}

