package org.thryft.waf.server.controllers.oauth;

import java.io.IOException;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.common.base.Optional;

public interface Oauth2ServiceProvider extends BaseApi<OAuth20Service> {
    public String getApiKey();

    public String getApiSecret();

    public Optional<String> getScope();

    public OauthUserProfile getUserProfile(OAuth20Service service, OAuth2AccessToken accessToken)
            throws IncompleteOAuthUserProfileException, IOException;
}
