package org.thryft.waf.server.controllers;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.inject.Singleton;

@SuppressWarnings("serial")
@Singleton
public class ExceptionLoggingHttpServlet extends HttpServlet {
    @Override
    protected void doGet(final HttpServletRequest req, final HttpServletResponse resp)
            throws ServletException, IOException {
        final Throwable throwable = (Throwable) req.getAttribute("javax.servlet.error.exception");
        if (throwable != null) {
            logger.error("uncaught exception: ", throwable);
            resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        } else {
            resp.sendError(HttpServletResponse.SC_NOT_FOUND);
        }
    }

    private final static Logger logger = LoggerFactory.getLogger(ExceptionLoggingHttpServlet.class);
}
