package org.thryft.waf.server.controllers.oauth;

import static com.google.common.base.Preconditions.checkNotNull;

import org.thryft.native_.Url;

import com.google.common.base.Optional;

public final class OauthUserProfile {
    public final static class Builder {
        private Builder() {
        }

        public OauthUserProfile build() {
            return new OauthUserProfile(emailAddress, firstName, id, lastName, name, picture);
        }

        public String getEmailAddress() {
            return emailAddress;
        }

        public Optional<String> getFirstName() {
            return firstName;
        }

        public String getId() {
            return id;
        }

        public Optional<String> getLastName() {
            return lastName;
        }

        public Optional<String> getName() {
            return name;
        }

        public Optional<Url> getPicture() {
            return picture;
        }

        public Builder setEmailAddress(final String emailAddress) {
            this.emailAddress = checkNotNull(emailAddress);
            return this;
        }

        public Builder setFirstName(final Optional<String> firstName) {
            this.firstName = checkNotNull(firstName);
            return this;
        }

        public Builder setId(final String id) {
            this.id = checkNotNull(id);
            return this;
        }

        public Builder setLastName(final Optional<String> lastName) {
            this.lastName = checkNotNull(lastName);
            return this;
        }

        public Builder setName(final Optional<String> name) {
            this.name = checkNotNull(name);
            return this;
        }

        public Builder setPicture(final Optional<Url> picture) {
            this.picture = checkNotNull(picture);
            return this;
        }

        private String emailAddress = null;
        private Optional<String> firstName = Optional.absent();
        private Optional<String> lastName = Optional.absent();
        private Optional<String> name = Optional.absent();
        private Optional<Url> picture = Optional.absent();
        private String id = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OauthUserProfile(final String emailAddress, final Optional<String> firstName, final String id,
            final Optional<String> lastName, final Optional<String> name, final Optional<Url> picture) {
        this.emailAddress = checkNotNull(emailAddress);
        this.firstName = checkNotNull(firstName);
        this.id = checkNotNull(id);
        this.lastName = checkNotNull(lastName);
        this.name = checkNotNull(name);
        this.picture = checkNotNull(picture);
    }

    public final String getEmailAddress() {
        return emailAddress;
    }

    public final Optional<String> getFirstName() {
        return firstName;
    }

    public final String getId() {
        return id;
    }

    public final Optional<String> getLastName() {
        return lastName;
    }

    public final Optional<String> getName() {
        return name;
    }

    public final Optional<Url> getPicture() {
        return picture;
    }

    private final String emailAddress;
    private final Optional<String> firstName;
    private final String id;
    private final Optional<String> lastName;
    private final Optional<String> name;
    private final Optional<Url> picture;
}
