/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.vaadin;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;

public class ExampleFilterDataProvider<T, ID extends Serializable>
implements ConfigurableFilterDataProvider<T, T, T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExampleFilterDataProvider.class);
    private final JpaRepository<T, ID> repository;
    private final ExampleMatcher matcher;
    private final List<QuerySortOrder> defaultSort;
    private final ConfigurableFilterDataProvider<T, T, T> delegate;
    private Finder<T, ID> finder;

    public ExampleFilterDataProvider(JpaRepository<T, ID> repository, ExampleMatcher matcher, List<QuerySortOrder> defaultSort) {
        this(repository, matcher, defaultSort, null);
    }

    public ExampleFilterDataProvider(JpaRepository<T, ID> repository, ExampleMatcher matcher, List<QuerySortOrder> defaultSort, Finder<T, ID> finder) {
        Preconditions.checkNotNull(defaultSort);
        Preconditions.checkArgument((defaultSort.size() > 0 ? 1 : 0) != 0, (Object)"At least one sort property must be specified!");
        this.repository = repository;
        this.matcher = matcher;
        this.defaultSort = defaultSort;
        this.finder = finder;
        this.delegate = this.buildDataProvider();
    }

    private ConfigurableFilterDataProvider<T, T, T> buildDataProvider() {
        CallbackDataProvider dataProvider = DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)q -> q.getFilter().map(document -> this.findAll(this.buildExample(document), ChunkRequest.of(q, this.defaultSort)).getContent()).orElseGet(() -> this.findAll(ChunkRequest.of(q, this.defaultSort)).getContent()).stream(), (CallbackDataProvider.CountCallback & Serializable)q -> Ints.checkedCast((long)q.getFilter().map(document -> this.countAll(this.buildExample(document))).orElseGet(() -> this.repository.count())));
        return dataProvider.withConfigurableFilter((SerializableBiFunction & Serializable)(q, c) -> c);
    }

    private Page<T> findAll(Pageable p) {
        if (this.finder == null) {
            return this.repository.findAll(p);
        }
        return this.finder.find(this.repository, p);
    }

    private Page<T> findAll(Example<T> ex, Pageable p) {
        if (this.finder == null) {
            return this.repository.findAll(ex, p);
        }
        return this.finder.find(this.repository, ex, p);
    }

    private Long countAll(Example<T> ex) {
        if (this.finder == null) {
            return this.repository.count(ex);
        }
        return this.finder.count(this.repository, ex);
    }

    private Example<T> buildExample(T probe) {
        return Example.of(probe, (ExampleMatcher)this.matcher);
    }

    public void setFilter(T filter) {
        this.delegate.setFilter(filter);
    }

    public boolean isInMemory() {
        return this.delegate.isInMemory();
    }

    public int size(Query<T, T> query) {
        return this.delegate.size(query);
    }

    public Stream<T> fetch(Query<T, T> query) {
        return this.delegate.fetch(query);
    }

    public void refreshItem(T item) {
        this.delegate.refreshItem(item);
    }

    public void refreshAll() {
        this.delegate.refreshAll();
    }

    public Object getId(T item) {
        return this.delegate.getId(item);
    }

    public Registration addDataProviderListener(DataProviderListener<T> listener) {
        return this.delegate.addDataProviderListener(listener);
    }

    public <C> DataProvider<T, C> withConvertedFilter(SerializableFunction<C, T> filterConverter) {
        return this.delegate.withConvertedFilter(filterConverter);
    }

    public <Q, C> ConfigurableFilterDataProvider<T, Q, C> withConfigurableFilter(SerializableBiFunction<Q, C, T> filterCombiner) {
        return this.delegate.withConfigurableFilter(filterCombiner);
    }

    public ConfigurableFilterDataProvider<T, Void, T> withConfigurableFilter() {
        return this.delegate.withConfigurableFilter();
    }

    public static interface Finder<T, ID> {
        public Page<T> find(JpaRepository<T, ID> var1, Example<T> var2, Pageable var3);

        public Page<T> find(JpaRepository<T, ID> var1, Pageable var2);

        public Long count(JpaRepository<T, ID> var1, Example<T> var2);
    }

    private static class ChunkRequest
    implements Pageable {
        public static final Logger LOGGER = LoggerFactory.getLogger(ChunkRequest.class);
        private final Sort sort;
        private int limit = 0;
        private int offset = 0;

        public static <T> ChunkRequest of(Query<T, T> q, List<QuerySortOrder> defaultSort) {
            return new ChunkRequest(q.getOffset(), q.getLimit(), ChunkRequest.mapSort(q.getSortOrders(), defaultSort));
        }

        private static Sort mapSort(List<QuerySortOrder> sortOrders, List<QuerySortOrder> defaultSort) {
            LOGGER.info("map sort: {} , {}", sortOrders, defaultSort);
            if (sortOrders == null || sortOrders.isEmpty()) {
                return Sort.by((Sort.Order[])ChunkRequest.mapSortCriteria(defaultSort));
            }
            return Sort.by((Sort.Order[])ChunkRequest.mapSortCriteria(sortOrders));
        }

        private static Sort.Order[] mapSortCriteria(List<QuerySortOrder> sortOrders) {
            LOGGER.info("mapSortCriteria: {} , {}", sortOrders);
            for (QuerySortOrder qso : sortOrders) {
                LOGGER.info("qso: {}", qso.getSorted());
            }
            return (Sort.Order[])sortOrders.stream().map(s -> new Sort.Order(s.getDirection() == SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC, (String)s.getSorted())).toArray(Sort.Order[]::new);
        }

        private ChunkRequest(int offset, int limit, Sort sort) {
            Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset must not be less than zero!");
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"Limit must be greater than zero!");
            this.sort = sort;
            this.offset = offset;
            this.limit = limit;
        }

        public int getPageNumber() {
            return 0;
        }

        public int getPageSize() {
            return this.limit;
        }

        public long getOffset() {
            return this.offset;
        }

        public Sort getSort() {
            return this.sort;
        }

        public Pageable next() {
            return null;
        }

        public Pageable previousOrFirst() {
            return this;
        }

        public Pageable first() {
            return this;
        }

        public boolean hasPrevious() {
            return false;
        }
    }
}

