/*
 * Decompiled with CFR 0.152.
 */
package org.thshsh.vaadin;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="div")
public class GridField<S>
extends AbstractField<GridField<S>, Collection<S>> {
    public static final Logger LOGGER = LoggerFactory.getLogger(GridField.class);
    Grid<S> grid;
    ListDataProvider<S> dataProvider;
    BiFunction<S, S, Boolean> equalsMethod;

    public GridField(Grid<S> grid) {
        super(null);
        this.grid = grid;
        this.grid.addClassName("grid-field");
    }

    public Collection<S> getValue() {
        if (this.dataProvider == null) {
            return null;
        }
        return this.dataProvider.getItems();
    }

    public void removeItem(S item) {
        ArrayList value = this.getValue();
        value = value == null ? new ArrayList() : new ArrayList(value);
        value.remove(item);
        this.setValue(value);
    }

    public void addItem(S item) {
        ArrayList<Object> value = this.getValue();
        value = value == null ? new ArrayList<S>() : new ArrayList(value);
        value.add(item);
        this.setValue(value);
    }

    public void addItems(Iterable<S> items) {
        items.forEach(item -> this.addItem(item));
    }

    public void removeItems(Iterable<S> items) {
        items.forEach(item -> this.removeItem(item));
    }

    public Grid<S> getGrid() {
        return this.grid;
    }

    public ListDataProvider<S> getDataProvider() {
        return this.getOrCreateDataProvider();
    }

    public void setEqualsMethod(BiFunction<S, S, Boolean> eq) {
        this.equalsMethod = eq;
    }

    protected void setPresentationValue(Collection<S> values) {
        LOGGER.trace("setPresentationValue: {}", values);
        if (this.dataProvider == null) {
            LOGGER.debug("Cloning value");
            ArrayList clones = new ArrayList();
            values.forEach(obj -> clones.add(ObjectUtils.cloneIfPossible((Object)obj)));
            values = clones;
        }
        ListDataProvider<S> dataProvider = this.getOrCreateDataProvider();
        dataProvider.getItems().clear();
        dataProvider.getItems().addAll(values);
    }

    protected ListDataProvider<S> getOrCreateDataProvider() {
        if (this.dataProvider == null) {
            this.dataProvider = new ListDataProvider(new ArrayList());
            this.grid.setDataProvider(this.dataProvider);
        }
        return this.dataProvider;
    }

    protected boolean valueEquals(Collection<S> value1, Collection<S> value2) {
        boolean diff = super.valueEquals(value1, value2);
        LOGGER.debug("valueEquals {}", (Object)diff);
        if (!diff && this.equalsMethod != null) {
            Iterator<S> newValues = value1.iterator();
            Iterator<S> curValues = value2.iterator();
            while (newValues.hasNext()) {
                S newV = newValues.next();
                S curV = curValues.next();
                diff = this.equalsMethod.apply(curV, newV);
                if (diff) continue;
                break;
            }
        }
        return diff;
    }
}

